/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.shape;

import com.moderocky.guardian.logic.ascendancy.IOrder3;
import com.moderocky.guardian.logic.ascendancy.Polytope;
import com.moderocky.guardian.logic.handler.LogicUtils;
import com.moderocky.guardian.logic.handler.PolyProcessor;
import com.moderocky.guardian.logic.shape.Dion;
import com.moderocky.guardian.logic.shape.Polygon;
import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class Polyhedron
implements Polytope,
IOrder3 {
    private final List<Vertex> vertices;
    private final List<Integer> indices;
    private final int vertexCount;

    public Polyhedron(List<Vertex> vertices) {
        this.correctVertices(vertices);
        this.vertices = new ArrayList<Vertex>();
        this.indices = new ArrayList<Integer>();
        this.vertexCount = vertices.size();
        for (int i = 0; i < this.vertexCount; ++i) {
            this.vertices.add(vertices.get(i));
            this.indices.add(i);
        }
    }

    private Polyhedron(List<Vertex> vertices, boolean skipCorrection) {
        if (!skipCorrection) {
            this.correctVertices(vertices);
        }
        this.vertices = new ArrayList<Vertex>();
        this.indices = new ArrayList<Integer>();
        this.vertexCount = vertices.size();
        for (int i = 0; i < this.vertexCount; ++i) {
            this.vertices.add(vertices.get(i));
            this.indices.add(i);
        }
    }

    public static Polyhedron createCuboid(Vertex min, Vertex max) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(new Vertex(Math.min(min.getX(), max.getX()), Math.min(min.getY(), max.getY()), Math.min(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.min(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.min(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.min(min.getX(), max.getX()), Math.min(min.getY(), max.getY()), Math.max(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.min(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.max(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.max(min.getX(), max.getX()), Math.min(min.getY(), max.getY()), Math.min(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.max(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.min(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.max(min.getX(), max.getX()), Math.min(min.getY(), max.getY()), Math.max(min.getZ(), max.getZ())));
        vertices.add(new Vertex(Math.max(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.max(min.getZ(), max.getZ())));
        return new Polyhedron(vertices);
    }

    public static Polyhedron createCube(Vertex vertex, double diameter) {
        Vertex end = new Vertex(vertex.getX() + diameter, vertex.getY() + diameter, vertex.getZ() + diameter);
        return Polyhedron.createCuboid(vertex, end);
    }

    private void correctVertices(List<Vertex> vertices) {
        ArrayList<Vertex> workingCopy = new ArrayList<Vertex>(vertices);
        workingCopy.forEach(vertex -> {
            ArrayList<Vertex> temp = new ArrayList<Vertex>(workingCopy);
            temp.remove(vertex);
            PolyProcessor processor = new PolyProcessor(new Polyhedron(temp, true));
            if (processor.isInside((Vertex)vertex)) {
                vertices.remove(vertex);
            }
        });
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public BoundingBox getBoundingBox() {
        double maxZ;
        double maxY;
        double maxX;
        double minX = maxX = this.vertices.get(0).getX();
        double minY = maxY = this.vertices.get(0).getY();
        double minZ = maxZ = this.vertices.get(0).getZ();
        for (int i = 1; i < this.vertexCount; ++i) {
            if (this.vertices.get(i).getX() < minX) {
                minX = this.vertices.get(i).getX();
            }
            if (this.vertices.get(i).getY() < minY) {
                minY = this.vertices.get(i).getY();
            }
            if (this.vertices.get(i).getZ() < minZ) {
                minZ = this.vertices.get(i).getZ();
            }
            if (this.vertices.get(i).getX() > maxX) {
                maxX = this.vertices.get(i).getX();
            }
            if (this.vertices.get(i).getY() > maxY) {
                maxY = this.vertices.get(i).getY();
            }
            if (!(this.vertices.get(i).getZ() > maxZ)) continue;
            maxZ = this.vertices.get(i).getZ();
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public List<Location> getLocations(World world) {
        ArrayList<Location> locations = new ArrayList<Location>();
        this.vertices.forEach(vertex -> locations.add(vertex.toLocation(world)));
        return locations;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public Vertex[] vertices() {
        return this.vertices.toArray(new Vertex[0]);
    }

    @Override
    public boolean contains(Polytope polytope) {
        PolyProcessor processor = new PolyProcessor(this);
        for (Vertex vertex : polytope.vertices()) {
            if (processor.isInside(vertex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(@NotNull Polygon polygon) {
        PolyProcessor processor = new PolyProcessor(this);
        for (Vertex vertex : polygon.vertices()) {
            if (processor.isInside(vertex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Polyhedron[] polyhedrons() {
        return new Polyhedron[]{this};
    }

    @Override
    public boolean contains(@NotNull Dion dion) {
        PolyProcessor processor = new PolyProcessor(this);
        for (Vertex vertex : dion.vertices()) {
            if (processor.isInside(vertex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Polygon[] polygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Vertex[] trio : LogicUtils.getTrios(this.vertices)) {
            polygons.add(new Polygon(Arrays.asList(trio), Arrays.asList(0, 1, 2)));
        }
        return polygons.toArray(new Polygon[0]);
    }

    @Override
    public boolean contains(@NotNull Vertex vertex) {
        PolyProcessor processor = new PolyProcessor(this);
        return processor.isInside(vertex);
    }

    @Override
    public Dion[] dions() {
        ArrayList<Dion> dions = new ArrayList<Dion>();
        for (Vertex[] pair : LogicUtils.getPairs(this.vertices)) {
            dions.add(new Dion(pair[0], pair[1]));
        }
        return dions.toArray(new Dion[0]);
    }
}

