/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.shape;

import com.moderocky.guardian.logic.ascendancy.IOrder2;
import com.moderocky.guardian.logic.ascendancy.Polytope;
import com.moderocky.guardian.logic.handler.LogicUtils;
import com.moderocky.guardian.logic.handler.Plane;
import com.moderocky.guardian.logic.shape.Dion;
import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Polygon
implements Polytope,
IOrder2 {
    private final List<Vertex> vertices = new ArrayList<Vertex>();
    private final List<Integer> indices = new ArrayList<Integer>();
    private final int vertexCount;

    public Polygon(List<Vertex> vertices, List<Integer> integers) {
        this.vertexCount = vertices.size();
        for (int i = 0; i < this.vertexCount; ++i) {
            this.vertices.add(vertices.get(i));
            this.indices.add(integers.get(i));
        }
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public Vertex[] vertices() {
        return this.vertices.toArray(new Vertex[0]);
    }

    @Override
    public boolean contains(Polytope polytope) {
        for (Vertex vertex : polytope.vertices()) {
            if (this.contains(vertex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(@NotNull Dion dion) {
        return this.contains(dion.getStart()) && this.contains(dion.getEnd());
    }

    @Override
    public Polygon[] polygons() {
        return new Polygon[]{this};
    }

    @Override
    public boolean contains(@NotNull Vertex vertex) {
        for (Vertex[] trio : LogicUtils.getTrios(this.vertices)) {
            Plane plane = new Plane(trio[0], trio[1], trio[2]);
            double dis = Plane.multiple(vertex, plane);
            if (!(Math.abs(dis) < 0.001)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dion[] dions() {
        ArrayList<Dion> dions = new ArrayList<Dion>();
        for (Vertex[] pair : LogicUtils.getPairs(this.vertices)) {
            dions.add(new Dion(pair[0], pair[1]));
        }
        return dions.toArray(new Dion[0]);
    }
}

