/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerMoveListener
implements Listener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(PlayerMoveEvent event) {
        List<Zone> zFrom;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (!this.api.requiresMoveCheck(to) && !this.api.requiresMoveCheck(from)) {
            return;
        }
        List<Zone> zTo = this.api.getZones(to);
        if (!zTo.equals(zFrom = this.api.getZones(from))) {
            for (Zone zone : zTo) {
                if (zFrom.contains(zone) || zone.canInteract(to, "prevent_entry", player)) continue;
                event.setCancelled(true);
                this.api.denyEvent(player);
                break;
            }
        }
        if (!zTo.equals(zFrom)) {
            for (Zone zone : zFrom) {
                if (zTo.contains(zone) || zone.canInteract(from, "prevent_exit", player)) continue;
                event.setCancelled(true);
                this.api.denyEvent(player);
                break;
            }
        }
    }
}

