/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerInteractEntityListener
implements Listener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Location location = event.getRightClicked().getLocation();
        String hache = player.hashCode() + "0x14" + event.getRightClicked().hashCode() + location.getX() + "0" + location.getZ();
        Boolean boo = this.api.getCachedResult(hache);
        if (boo != null) {
            event.setCancelled(boo.booleanValue());
        } else {
            for (Zone zone : this.api.getZones(location)) {
                if (zone.canInteract(location, "interact_with_entities", player)) continue;
                event.setCancelled(true);
                this.api.addCachedResult(hache, true);
                this.api.denyEvent(player);
                return;
            }
            this.api.addCachedResult(hache, false);
        }
    }
}

