/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerAttemptPickupItemListener
implements Listener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(EntityPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Location location = event.getItem().getLocation();
        String hache = entity.hashCode() + "0x13" + location.getBlockX() + "0" + location.getBlockY() + "0" + location.getBlockZ();
        Boolean boo = this.api.getCachedResult(hache);
        if (boo != null) {
            event.setCancelled(boo.booleanValue());
        } else {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (Zone zone : this.api.getZones(location)) {
                    if (zone.canInteract(location, "pick_up_items", player)) continue;
                    event.setCancelled(true);
                    this.api.addCachedResult(hache, true);
                    this.api.denyEvent(player);
                    return;
                }
            } else {
                for (Zone zone : this.api.getZones(location)) {
                    if (zone.canInteract(location, "pick_up_items")) continue;
                    event.setCancelled(true);
                    this.api.addCachedResult(hache, true);
                    return;
                }
            }
            this.api.addCachedResult(hache, false);
        }
    }
}

