/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import org.bukkit.Location;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class InventoryOpenListener
implements Listener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof Container)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Location location = ((Container)holder).getLocation();
        String hache = player.hashCode() + "0x12" + holder.hashCode();
        Boolean boo = this.api.getCachedResult(hache);
        if (boo != null) {
            event.setCancelled(boo.booleanValue());
        } else {
            for (Zone zone : this.api.getZones(location)) {
                if (zone.canInteract(location, "open_containers", player)) continue;
                event.setCancelled(true);
                this.api.addCachedResult(hache, true);
                this.api.denyEvent(player);
                return;
            }
            this.api.addCachedResult(hache, false);
        }
    }
}

