/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.config;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.mask.annotation.Configurable;
import com.moderocky.guardian.mask.gui.ItemFactory;
import com.moderocky.guardian.mask.mirror.Mirror;
import com.moderocky.guardian.mask.template.Config;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class GuardianConfig
implements Config {
    @Configurable(value="wand")
    public boolean enableWand = true;
    @Configurable.Comment(value={"Any Bukkit Material enum is permitted."})
    @Configurable(value="wand")
    public Material wandMaterial = Material.DEBUG_STICK;
    @Configurable.Comment(value={"Allows a custom model data value to be used for the wand."})
    @Configurable(value="wand")
    @Configurable.Bounded(minValue=0.0, maxValue=9.99999999E8)
    public int wandModelData = 102;
    @Configurable.Comment(value={"Any Bukkit Material enum is permitted."})
    @Configurable(value="wand")
    public Material polywandMaterial = Material.DEBUG_STICK;
    @Configurable.Comment(value={"Allows a custom model data value to be used for the wand."})
    @Configurable(value="wand")
    @Configurable.Bounded(minValue=0.0, maxValue=9.99999999E8)
    public int polywandModelData = 103;
    @Configurable.Comment(value={"Use '%s' to indicate the position number."})
    @Configurable(value="wand")
    public String setPosition = "Set Zone Position #%s";
    @Configurable(value="wand")
    public String clearPosition = "Cleared Zone Positions";
    @Configurable.Comment(value={"The maximum diameter for a player-created zone.", "This goes from corner to corner."})
    @Configurable(value="zone")
    @Configurable.Bounded(minValue=1.0, maxValue=100000.0)
    public long maxZoneDiameter = 128L;
    @Configurable(value="zone")
    public String actionDenyMessage = "\u00a7bYou cannot interact with this zone!";
    @Configurable.Comment(value={"Allows use of the zone enter/exit flags.", "Might affect server performance if misused."})
    @Configurable(value="settings")
    public boolean checkEntryExit = true;
    @Configurable.Comment(value={"Allowed values are TRUE, OP, NOT_OP and FALSE."})
    @Configurable(value="settings")
    public PermissionDefault allowBasicFlags = PermissionDefault.TRUE;
    @Configurable.Comment(value={"Allowed values are TRUE, OP, NOT_OP and FALSE."})
    @Configurable(value="settings")
    public PermissionDefault allowSpecialFlags = PermissionDefault.OP;
    @Configurable.Comment(value={"Delay between saving to file - in seconds."})
    @Configurable(value="settings")
    @Configurable.Bounded(minValue=10.0, maxValue=100000.0)
    public long saveDelay = 100L;
    @Configurable.Comment(value={"Delay between clearing action caches (used to speed up the plugin) - in seconds.", "Longer delays will increase performance, but have the potential to cause false blocking."})
    @Configurable(value="settings")
    public long actionCacheResetDelay = 30L;
    @Configurable(value="settings")
    @Configurable.Comment(value={"Compress the stored zone data?"})
    public boolean compressData = true;

    public GuardianConfig() {
        this.load();
    }

    @Override
    @NotNull
    public String getFolderPath() {
        return "plugins/Guardian/";
    }

    @Override
    @NotNull
    public String getFileName() {
        return "config.yml";
    }

    public ItemStack getWand() {
        return new ItemFactory(this.wandMaterial, 1, itemMeta -> {
            itemMeta.setCustomModelData(Integer.valueOf(this.wandModelData));
            itemMeta.setDisplayName("\u00a76Zone Wand");
            itemMeta.setLore(Arrays.asList("\u00a77LClick to set Pos #1", "\u00a77RClick to set Pos #2"));
            itemMeta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            if (Mirror.classExists("co.aikar.timings.Timing")) {
                new Mirror<ItemMeta>((ItemMeta)itemMeta).method("setDestroyableKeys", Collection.class).invoke(Collections.emptyList());
            }
            itemMeta.getPersistentDataContainer().set(Guardian.getNamespacedKey("wand"), PersistentDataType.BYTE, (Object)1);
            itemMeta.addItemFlags(ItemFlag.values());
        }).create();
    }

    public ItemStack getPolywand() {
        return new ItemFactory(this.polywandMaterial, 1, itemMeta -> {
            itemMeta.setCustomModelData(Integer.valueOf(this.polywandModelData));
            itemMeta.setDisplayName("\u00a76Zone Polywand");
            itemMeta.setLore(Arrays.asList("\u00a77LClick to add a vertex", "\u00a77RClick to reset vertices"));
            itemMeta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            if (Mirror.classExists("co.aikar.timings.Timing")) {
                new Mirror<ItemMeta>((ItemMeta)itemMeta).method("setDestroyableKeys", Collection.class).invoke(Collections.emptyList());
            }
            itemMeta.getPersistentDataContainer().set(Guardian.getNamespacedKey("polywand"), PersistentDataType.BYTE, (Object)1);
            itemMeta.addItemFlags(ItemFlag.values());
        }).create();
    }
}

