/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.common.base.Ascii;
import com.google.gson.JsonObject;
import com.moderocky.guardian.api.WorldDistrict;
import com.moderocky.guardian.mask.api.commons.Describable;
import com.moderocky.guardian.mask.api.commons.Nameable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public abstract class Zone
implements Nameable,
Describable {
    @NotNull
    private final List<String> flags = new ArrayList<String>();
    @NotNull
    private final List<UUID> players = new ArrayList<UUID>();
    @NotNull
    private final NamespacedKey key;
    private Chunk[] chunks = null;

    public Zone(@NotNull NamespacedKey id) {
        this.key = id;
    }

    public Zone(@NotNull NamespacedKey id, @NotNull JsonObject object) {
        this.key = id;
    }

    public List<UUID> getAllowedPlayers() {
        return this.players;
    }

    public void addPlayer(UUID uuid) {
        this.players.add(uuid);
    }

    public void removePlayer(UUID uuid) {
        this.players.remove(uuid);
    }

    public boolean isAllowed(UUID player) {
        return this.players.contains(player);
    }

    public void clearPlayers() {
        this.players.clear();
    }

    @NotNull
    public final List<String> getFlags() {
        return this.flags;
    }

    public void clearFlags() {
        this.flags.clear();
    }

    public void addFlag(@NotNull String flag) {
        if (!this.flags.contains(flag)) {
            this.flags.add(flag);
        }
    }

    public void removeFlag(@NotNull String flag) {
        this.flags.remove(flag);
    }

    public boolean hasFlag(@NotNull String flag) {
        return this.flags.contains(flag);
    }

    public double getCuboidalSize() {
        BoundingBox box = this.getBoundingBox();
        return box.getWidthX() * box.getWidthZ() * box.getHeight();
    }

    public <Z extends Zone> boolean overlaps(Z zone) {
        double d = this.getLocation().distance(zone.getLocation());
        return d < this.getRadius() + zone.getRadius() || zone.overlaps((Zone)this);
    }

    public WorldDistrict getDistrict() {
        return new WorldDistrict(this.getLocation());
    }

    @Override
    public String getName() {
        return this.convertCase(this.getKey().getKey());
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public abstract int getWeight();

    public abstract double getRadius();

    public abstract boolean isInside(@NotNull Location var1);

    public boolean canInteract(@NotNull Location location, @NotNull String interactionType) {
        return !this.flags.contains(interactionType);
    }

    public boolean canInteract(@NotNull Location location, @NotNull String interactionType, @NotNull Player player) {
        return !this.flags.contains(interactionType) || this.isAllowed(player.getUniqueId());
    }

    public abstract boolean canEdit(@NotNull UUID var1);

    @NotNull
    public abstract List<Block> getBlocks();

    @NotNull
    public abstract BoundingBox getBoundingBox();

    @NotNull
    public Chunk[] getChunks() {
        if (this.chunks != null) {
            return this.chunks;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World world = this.getWorld();
        Location location1 = this.getBoundingBox().getMin().toLocation(world);
        Location location2 = this.getBoundingBox().getMax().toLocation(world);
        int xMin = location1.getChunk().getX();
        int xMax = location2.getChunk().getX();
        int zMin = location1.getChunk().getZ();
        int zMax = location2.getChunk().getZ();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                chunks.add(world.getChunkAt(x, z));
            }
        }
        this.chunks = chunks.toArray(new Chunk[0]);
        return this.chunks;
    }

    @NotNull
    public abstract World getWorld();

    @NotNull
    public abstract Location getLocation();

    public abstract void save(@NotNull JsonObject var1);

    public abstract void load(@NotNull JsonObject var1);

    private String convertCase(String string) {
        String[] words = string.split("_");
        ArrayList<String> list = new ArrayList<String>();
        for (String word : words) {
            list.add(word.isEmpty() ? word : Ascii.toUpperCase((char)word.charAt(0)) + Ascii.toLowerCase((String)word.substring(1)));
        }
        return String.join((CharSequence)" ", list);
    }
}

