/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.logic.handler.LogicUtils;
import com.moderocky.guardian.logic.handler.PolyProcessor;
import com.moderocky.guardian.logic.shape.Polyhedron;
import com.moderocky.guardian.logic.shape.Vertex;
import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.util.ParticleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolyhedralZone
extends Zone {
    private GuardianAPI api;
    private Polyhedron polyhedron;
    private BoundingBox boundingBox;
    private Location location;
    private UUID owner;
    private String name = null;
    private String description = null;

    public PolyhedralZone(@NotNull NamespacedKey id) {
        super(id);
        throw new IllegalArgumentException("This constructor may not be used!");
    }

    public PolyhedralZone(@NotNull String id, Location ... locations) {
        super(Guardian.getNamespacedKey(id));
        this.api = Guardian.getApi();
        this.polyhedron = new Polyhedron(LogicUtils.toVertices(Arrays.asList(locations)));
        this.boundingBox = this.polyhedron.getBoundingBox();
        this.location = this.boundingBox.getCenter().toLocation(locations[0].getWorld());
    }

    public PolyhedralZone(@NotNull NamespacedKey id, @NotNull JsonObject section) {
        super(id, section);
    }

    public static PolyhedralZone createZone(Player player, String id, Location ... locations) {
        PolyhedralZone zone = new PolyhedralZone(id, locations);
        zone.setOwner(player.getUniqueId());
        return zone;
    }

    public static PolyhedralZone createZone(String id, Location ... locations) {
        PolyhedralZone zone = new PolyhedralZone(id, locations);
        zone.setOwner(null);
        return zone;
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Polyhedron getPolyhedron() {
        return this.polyhedron;
    }

    private PolyProcessor getPolyProcessor() {
        return new PolyProcessor(this.polyhedron);
    }

    @Override
    public <Z extends Zone> boolean overlaps(Z zone) {
        if (zone instanceof PolyhedralZone) {
            return this.overlaps((PolyhedralZone)zone);
        }
        if (zone instanceof CuboidalZone) {
            return this.overlaps((CuboidalZone)zone);
        }
        return super.overlaps(zone);
    }

    public boolean overlaps(PolyhedralZone zone) {
        PolyProcessor processor = this.getPolyProcessor();
        for (Vertex vertex : zone.getPolyhedron().getVertices()) {
            if (!processor.isInside(vertex)) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(CuboidalZone zone) {
        PolyProcessor processor = this.getPolyProcessor();
        for (Vertex vertex : LogicUtils.getVertices(zone.getBoundingBox())) {
            if (!processor.isInside(vertex)) continue;
            return true;
        }
        return false;
    }

    public boolean eclipses(PolyhedralZone zone) {
        PolyProcessor processor = this.getPolyProcessor();
        for (Vertex vertex : zone.getPolyhedron().getVertices()) {
            if (processor.isInside(vertex)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        if (owner != null && !this.isAllowed(owner)) {
            this.addPlayer(owner);
        }
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public double getRadius() {
        return this.boundingBox.getMax().distance(this.boundingBox.getMin()) / 2.0 + 2.0;
    }

    @Override
    public boolean isInside(@NotNull Location location) {
        PolyProcessor processor = this.getPolyProcessor();
        return location.getWorld() == this.getWorld() && processor.isInside(Vertex.from(location));
    }

    @Override
    public boolean canEdit(@NotNull UUID player) {
        return player.equals(this.getOwner()) || Bukkit.getOfflinePlayer((UUID)player).isOp();
    }

    @Override
    @NotNull
    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>(LogicUtils.getBlocks(this.getBoundingBox(), this.getWorld()));
        blocks.removeIf(block -> !this.isInside(block.getLocation().add(0.5, 0.5, 0.5)));
        return blocks;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void showBounds() {
        ParticleUtils.drawHash(Particle.END_ROD, 0.25, this.polyhedron.getLocations(this.getWorld()).toArray(new Location[0]));
    }

    @Override
    public void save(@NotNull JsonObject object) {
        this.api = Guardian.getApi();
        World world = this.getWorld();
        object.addProperty("location", this.api.serialisePosition(this.getLocation()));
        MagicList strings = new MagicList();
        this.polyhedron.getLocations(world).forEach(location -> strings.add(this.api.serialisePosition((Location)location)));
        object.add("vertices", (JsonElement)strings.toJsonStringArray());
        object.add("flags", (JsonElement)new MagicList<String>((Collection<String>)this.getFlags()).toJsonStringArray());
        MagicList<String> players = new MagicList<UUID>((Collection<UUID>)this.getAllowedPlayers()).collect(UUID::toString);
        object.add("players", (JsonElement)players.toJsonStringArray());
        object.addProperty("owner", this.getOwner() != null ? this.getOwner().toString() : null);
        object.addProperty("name", this.name);
        object.addProperty("description", this.description);
    }

    @Override
    public void load(@NotNull JsonObject object) {
        this.api = Guardian.getApi();
        this.location = this.api.deserialisePosition(object.get("location").getAsString());
        MagicList<Vertex> vertices = MagicList.from(object.getAsJsonArray("vertices"), JsonElement::getAsString).collect(string -> this.api.deserialisePosition((String)string)).collect(Vertex::from);
        this.polyhedron = new Polyhedron(vertices);
        this.boundingBox = this.polyhedron.getBoundingBox();
        for (String string2 : MagicList.from(object.getAsJsonArray("flags"), JsonElement::getAsString)) {
            this.addFlag(string2);
        }
        for (String string2 : MagicList.from(object.getAsJsonArray("players"), JsonElement::getAsString)) {
            this.addPlayer(UUID.fromString(string2));
        }
        if (object.has("owner") && object.get("owner").isJsonPrimitive()) {
            String string3 = object.get("owner").getAsString();
            this.setOwner(UUID.fromString(string3));
        } else {
            this.setOwner(null);
        }
        this.name = object.get("name") != null && !object.get("name").isJsonNull() ? object.get("name").getAsString() : null;
        this.description = !object.has("description") || object.get("description").isJsonNull() ? null : object.get("description").getAsString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String s) {
        this.description = s;
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }
}

