/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.EventMethRef;
import com.moderocky.guardian.api.Parent;
import com.moderocky.guardian.api.WorldDistrict;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.listener.BlanketUncaughtListener;
import com.moderocky.guardian.mask.annotation.DoNotInstantiate;
import com.moderocky.guardian.mask.annotation.Internal;
import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.mask.command.Commander;
import com.moderocky.guardian.mask.internal.utility.FileManager;
import com.moderocky.guardian.mask.mirror.Mirror;
import com.moderocky.guardian.util.Messenger;
import com.moderocky.guardian.util.ParticleUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuardianAPI {
    public static final JsonParser PARSER = new JsonParser();
    @NotNull
    private final HashMap<NamespacedKey, Zone> zoneMap = new HashMap();
    @NotNull
    private final HashMap<World, List<NamespacedKey>> worldCache = new HashMap();
    @NotNull
    private final HashMap<WorldDistrict, List<NamespacedKey>> worldDistrictCache = new HashMap();
    @NotNull
    private final List<String> protectionFlags = new ArrayList<String>();
    @NotNull
    private final HashMap<Chunk, Boolean> chunkMoveCheckCache = new HashMap();
    @NotNull
    private final HashMap<String, Boolean> eventResultCache = new HashMap();
    @NotNull
    private final HashMap<Block, List<Zone>> locationZoneCache = new HashMap();
    @NotNull
    private final HashMap<Class<Event>, EventMethRef> blindEventMap = new HashMap();
    private GuardianConfig config;

    @Internal
    @DoNotInstantiate
    public GuardianAPI() {
    }

    public void init() {
        this.config = Guardian.getInstance().getGuardianConfig();
        this.protectionFlags.clear();
        this.reload();
        this.addProtectionFlag("mob_griefing", this.config.allowBasicFlags);
        this.addProtectionFlag("mob_spawning", this.config.allowBasicFlags);
        this.addProtectionFlag("break_blocks", this.config.allowBasicFlags);
        this.addProtectionFlag("place_blocks", this.config.allowBasicFlags);
        this.addProtectionFlag("damage_players", this.config.allowBasicFlags);
        this.addProtectionFlag("damage_entities", this.config.allowBasicFlags);
        this.addProtectionFlag("damage_vehicles", this.config.allowBasicFlags);
        this.addProtectionFlag("open_containers", this.config.allowBasicFlags);
        this.addProtectionFlag("pick_up_items", this.config.allowBasicFlags);
        this.addProtectionFlag("interact_with_blocks", this.config.allowBasicFlags);
        this.addProtectionFlag("interact_with_entities", this.config.allowBasicFlags);
        this.addProtectionFlag("prevent_tree_growth", this.config.allowBasicFlags);
        if (this.config.checkEntryExit) {
            this.addProtectionFlag("prevent_entry", this.config.allowBasicFlags);
            this.addProtectionFlag("prevent_exit", this.config.allowBasicFlags);
        }
        this.addProtectionFlag("prevent_commands", this.config.allowSpecialFlags);
        this.addProtectionFlag("prevent_chat", this.config.allowSpecialFlags);
        this.addProtectionFlag("prevent_teleport", this.config.allowSpecialFlags);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Guardian.getInstance(), this::save, 300L, this.config.saveDelay * 20L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Guardian.getInstance(), this::updateCache, 300L, this.config.actionCacheResetDelay * 20L);
    }

    public void registerBlindEvent(EventMethRef methRef) {
        try {
            this.blindEventMap.put(methRef.getEventClass(), methRef);
            Class<Event> eventClass = methRef.getEventClass();
            Method method = eventClass.getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            HandlerList list = (HandlerList)method.invoke(null, new Object[0]);
            for (Map.Entry entry : Guardian.getInstance().getPluginLoader().createRegisteredListeners((Listener)new BlanketUncaughtListener(), (Plugin)Guardian.getInstance()).entrySet()) {
                list.registerAll((Collection)entry.getValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ItemStack getWand() {
        return this.config.getWand();
    }

    public ItemStack getPolywand() {
        return this.config.getPolywand();
    }

    public boolean isWand(ItemStack itemStack) {
        NamespacedKey key;
        PersistentDataContainer container = itemStack.getItemMeta().getPersistentDataContainer();
        Byte bi = (Byte)container.get(key = Guardian.getNamespacedKey("wand"), PersistentDataType.BYTE);
        return bi != null && bi == 1;
    }

    public boolean isPolywand(ItemStack itemStack) {
        NamespacedKey key;
        PersistentDataContainer container = itemStack.getItemMeta().getPersistentDataContainer();
        Byte bi = (Byte)container.get(key = Guardian.getNamespacedKey("polywand"), PersistentDataType.BYTE);
        return bi != null && bi == 1;
    }

    public EventMethRef getMethRef(Class<? extends Event> eventClass) {
        return this.blindEventMap.get(eventClass);
    }

    public void updateCache() {
        this.chunkMoveCheckCache.clear();
        this.eventResultCache.clear();
        this.locationZoneCache.clear();
    }

    public Boolean getCachedResult(String hashedEvent) {
        return this.eventResultCache.get(hashedEvent);
    }

    public void addCachedResult(String hashedEvent, boolean isCancelled) {
        this.eventResultCache.put(hashedEvent, isCancelled);
    }

    public void addProtectionFlag(String flag) {
        this.protectionFlags.add(flag);
        Bukkit.getPluginManager().addPermission(new Permission("guardian.flag." + flag, PermissionDefault.TRUE));
    }

    public void addProtectionFlag(String flag, PermissionDefault perm) {
        this.protectionFlags.add(flag);
        Bukkit.getPluginManager().addPermission(new Permission("guardian.flag." + flag, perm));
    }

    public boolean isProtectionFlag(String flag) {
        return this.protectionFlags.contains(flag);
    }

    @NotNull
    public List<String> getProtectionFlags() {
        return new ArrayList<String>(this.protectionFlags);
    }

    public Location getWandPosition(Player player, int i) {
        int pos = Math.max(1, Math.min(2, i));
        String string = (String)player.getPersistentDataContainer().get(Guardian.getNamespacedKey("wand_pos_" + pos), PersistentDataType.STRING);
        if (string == null) {
            return null;
        }
        try {
            return this.deserialisePosition(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setWandPosition(Player player, int i, Location location) {
        if (i == 1) {
            player.getPersistentDataContainer().set(Guardian.getNamespacedKey("wand_pos_1"), PersistentDataType.STRING, (Object)this.serialisePosition(location.getBlock().getLocation()));
            location.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 12, (Object)Material.REDSTONE_BLOCK.createBlockData());
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)this.config.setPosition.replace("%s", "1")));
        } else if (i == 2) {
            player.getPersistentDataContainer().set(Guardian.getNamespacedKey("wand_pos_2"), PersistentDataType.STRING, (Object)this.serialisePosition(location.getBlock().getLocation()));
            location.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 12, (Object)Material.LAPIS_BLOCK.createBlockData());
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)this.config.setPosition.replace("%s", "2")));
        }
        this.displayBox(player);
    }

    public List<Location> getPolywandPositions(Player player) {
        String string = (String)player.getPersistentDataContainer().get(Guardian.getNamespacedKey("polywand_pos"), PersistentDataType.STRING);
        if (string == null || string.length() < 1) {
            return new ArrayList<Location>();
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String s : string.split("/")) {
            locations.add(this.deserialisePosition(s));
        }
        return locations;
    }

    public boolean requiresMoveCheck(Location location) {
        Chunk chunk = location.getChunk();
        if (this.chunkMoveCheckCache.containsKey(chunk)) {
            return this.chunkMoveCheckCache.get(chunk);
        }
        List<NamespacedKey> keys = this.getZones(chunk.getWorld());
        for (NamespacedKey key : keys) {
            Zone zone = this.getZone(key);
            if (!zone.getFlags().contains("prevent_entry") && !zone.getFlags().contains("prevent_exit") || !Arrays.asList(zone.getChunks()).contains(chunk)) continue;
            this.chunkMoveCheckCache.put(chunk, true);
            return true;
        }
        this.chunkMoveCheckCache.put(chunk, false);
        return false;
    }

    public boolean getInteractionResult(String flag, Location location) {
        List<Zone> zones = this.getZones(location);
        if (zones.isEmpty()) {
            return true;
        }
        for (Zone zone : zones) {
            if (zone.canInteract(location, flag)) continue;
            return false;
        }
        return true;
    }

    public boolean getInteractionResult(String flag, Location location, Player player) {
        List<Zone> zones = this.getZones(location);
        if (zones.isEmpty()) {
            return true;
        }
        for (Zone zone : zones) {
            if (zone.canInteract(location, flag, player)) continue;
            return false;
        }
        return true;
    }

    public String createHache(String flag, Location ... locations) {
        StringBuilder hache = new StringBuilder(flag.hashCode() + "x");
        for (Location l : locations) {
            hache.append("x").append(Math.floor(l.getX())).append("0").append(Math.floor(l.getY())).append("0").append(Math.floor(l.getZ()));
        }
        return hache.toString().trim();
    }

    public String createHache(String flag, Player player, Location ... locations) {
        StringBuilder hache = new StringBuilder(flag.hashCode() + "x");
        for (Location l : locations) {
            hache.append("x").append(Math.floor(l.getX())).append("0").append(Math.floor(l.getY())).append("0").append(Math.floor(l.getZ()));
        }
        return hache.toString().trim();
    }

    public void denyEvent(Player player) {
        if (this.config.actionDenyMessage != null) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)this.config.actionDenyMessage));
        }
    }

    public void displayBlocks(Zone zone, final Player player) {
        final List<Block> blocks = zone.getBlocks();
        for (Block block : blocks) {
            player.sendBlockChange(block.getLocation(), Material.WHITE_STAINED_GLASS.createBlockData());
        }
        new BukkitRunnable(){

            public void run() {
                for (Block block : blocks) {
                    player.sendBlockChange(block.getLocation(), block.getBlockData());
                }
            }
        }.runTaskLater((Plugin)Guardian.getInstance(), 30L);
    }

    public void displayBox(Player player) {
        Location l1 = this.getWandPosition(player, 1);
        Location l2 = this.getWandPosition(player, 2);
        if (l1 == null || l2 == null || l1.getWorld() != l2.getWorld() || l1.distanceSquared(l2) > (double)(this.config.maxZoneDiameter * this.config.maxZoneDiameter)) {
            return;
        }
        double d = Math.max(0.25, Math.min(1.0, l1.distanceSquared(l2) / ((double)(this.config.maxZoneDiameter * this.config.maxZoneDiameter) - l1.distanceSquared(l2))));
        BoundingBox box = BoundingBox.of((Location)l1, (Location)l2).expand(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ParticleUtils.drawBox(Particle.END_ROD, null, box, l1.getWorld(), d);
        this.highlightBlock(l1.getBlock(), Particle.FALLING_DUST, Material.REDSTONE_BLOCK.createBlockData());
        this.highlightBlock(l2.getBlock(), Particle.FALLING_DUST, Material.LAPIS_BLOCK.createBlockData());
    }

    public void displayPolyBox(Player player) {
        List<Location> locations = this.getPolywandPositions(player);
        ParticleUtils.drawHash(Particle.END_ROD, 0.25, locations.toArray(new Location[0]));
        locations.forEach(location -> this.highlightBlock(location.getBlock(), Particle.FALLING_DUST, Material.REDSTONE_BLOCK.createBlockData()));
    }

    public void displayBox(BoundingBox boundingBox, World world, Player player) {
        ParticleUtils.drawBox(Particle.END_ROD, null, boundingBox, world, 0.25);
    }

    public void displayBox(BoundingBox boundingBox, World world, Particle particle, @Nullable Object data) {
        ParticleUtils.drawBox(particle, data, boundingBox, world, 0.25);
    }

    public void highlightBlock(Block block, Particle particle, @Nullable Object data) {
        BoundingBox box = BoundingBox.of((Location)block.getLocation(), (Location)block.getLocation());
        ParticleUtils.drawBox(particle, data, box, block.getWorld(), 0.15);
    }

    public String serialisePosition(Location location) {
        return location.getWorld().getName() + ":" + location.getX() + ":" + location.getY() + ":" + location.getZ();
    }

    public Location deserialisePosition(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] parts = string.split(":");
        if (parts.length == 4) {
            World w = Bukkit.getServer().getWorld(parts[0]);
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            return new Location(w, x, y, z);
        }
        throw new IllegalArgumentException();
    }

    public boolean canCreateZone(Zone zone, Player player) {
        for (NamespacedKey nearbyZone : this.getZones(zone.getWorld())) {
            if (!this.zoneMap.get(nearbyZone).overlaps(zone) || this.zoneMap.get(nearbyZone).canEdit(player.getUniqueId())) continue;
            return false;
        }
        return true;
    }

    public List<NamespacedKey> getZoneKeys() {
        return new ArrayList<NamespacedKey>(this.zoneMap.keySet());
    }

    public List<Zone> getZones() {
        return new ArrayList<Zone>(this.zoneMap.values());
    }

    public void registerZone(Zone zone) {
        this.zoneMap.put(zone.getKey(), zone);
        this.addCache(zone);
    }

    public void removeZone(Zone zone) {
        this.zoneMap.remove(zone.getKey());
        this.removeCache(zone);
    }

    public BaseComponent[] getCommandHelpMessage(Commander<?> commander) {
        ComponentBuilder builder = new ComponentBuilder("Command Help:");
        for (Map.Entry<String, String> entry : commander.getPatternDescriptions().entrySet()) {
            boolean has;
            String pattern = entry.getKey();
            BaseComponent[] formatted = this.getFormattedPattern(pattern);
            String desc = entry.getValue();
            boolean bl = has = desc != null;
            HoverEvent event = desc != null ? new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)desc)) : new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(pattern.contains("[") || pattern.contains("<") ? "Click to suggest." : "Click to run."), (ChatColor)ChatColor.AQUA));
            builder.append("\n").retain(ComponentBuilder.FormatRetention.FORMATTING).append(" - ").color(Messenger.color("#f28900", '8')).event(new ClickEvent(pattern.contains("[") || pattern.contains("<") ? ClickEvent.Action.SUGGEST_COMMAND : ClickEvent.Action.RUN_COMMAND, "/" + commander.getCommand() + " " + pattern.replaceFirst("(<.*|\\[.*)", ""))).event(event).append("/" + commander.getCommand()).color(Messenger.color("#086796", '8')).append(" ").append(formatted);
        }
        return builder.create();
    }

    private BaseComponent[] getFormattedPattern(String pattern) {
        ChatColor color = Messenger.color("#29ffdb", '7');
        ChatColor star = Messenger.color("#f28900", '6');
        ChatColor angular = Messenger.color("#d9dbdb", 'f');
        ChatColor box = Messenger.color("#6d7070", '8');
        if (pattern.contains("[") || pattern.contains("<")) {
            return TextComponent.fromLegacyText((String)pattern.replace("\\*", star + "*" + color).replaceAll("<", angular + "<" + color).replaceAll(">", angular + ">" + color).replaceAll("\\[", box + "[" + color).replaceAll("]", box + "]" + color), (ChatColor)color);
        }
        return TextComponent.fromLegacyText((String)pattern, (ChatColor)color);
    }

    private MagicList<String> getArgPatterns(Commander<?> commander) {
        Pattern pattern = Pattern.compile("^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$");
        MagicList<String> list = new MagicList<String>((Collection<String>)commander.getPossibleArguments(new String[0]));
        MagicList<String> catcher = new MagicList<String>((Collection<String>)list);
        catcher.removeIf(s -> !s.contains("<") && !s.contains("["));
        catcher.removeIf(s -> !s.matches("^[^\\[<\\n]+((?> [<\\[]\\S+[\\]>])+)$"));
        for (String string : new ArrayList<String>(catcher)) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String group = matcher.group(1).trim();
            String test = string.replace(group, "").trim();
            boolean matches = false;
            for (String str : new ArrayList<String>(list)) {
                if (!str.trim().equalsIgnoreCase(test)) continue;
                matches = true;
                list.remove(str);
            }
            if (!matches) continue;
            list.remove(string);
            list.add(group.contains("<") ? test + " [" + group + "]" : test + " " + group);
        }
        return list;
    }

    public List<String> getTabCompletions(Commander<?> commander, String[] args) {
        MagicList<String> strings = commander.getTabCompletions(args);
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)args[args.length - 1], strings, completions);
        Collections.sort(completions);
        return completions;
    }

    public boolean exists(NamespacedKey key) {
        return this.zoneMap.containsKey(key);
    }

    public List<NamespacedKey> getZones(World world) {
        return new ArrayList<NamespacedKey>(this.worldCache.getOrDefault(world, new ArrayList()));
    }

    public List<NamespacedKey> getNearbyZones(WorldDistrict district) {
        return new ArrayList<NamespacedKey>(this.worldDistrictCache.getOrDefault(district, new ArrayList()));
    }

    @NotNull
    public List<Zone> getZones(Location location) {
        Block block = location.getBlock();
        if (this.locationZoneCache.containsKey(block)) {
            return new ArrayList<Zone>((Collection)this.locationZoneCache.get(block));
        }
        ArrayList<Zone> list = new ArrayList<Zone>();
        for (Zone zone : this.getZones()) {
            Parent parent;
            if (location.getWorld() != zone.getWorld() || !zone.getBoundingBox().contains(location.toVector())) continue;
            if (zone.isInside(location)) {
                list.add(zone);
            }
            if (!(zone instanceof Parent) || !(parent = (Parent)((Object)zone)).hasChildren()) continue;
            for (Zone child : parent.getChildren()) {
                if (location.distanceSquared(child.getLocation()) > child.getRadius() * child.getRadius() || !child.isInside(location)) continue;
                list.add(child);
            }
        }
        this.locationZoneCache.put(block, list);
        return list;
    }

    public boolean exists(String namespace, String key) {
        return this.zoneMap.containsKey(new NamespacedKey(namespace, key));
    }

    public boolean exists(String key) {
        if (key.contains(":")) {
            return this.zoneMap.containsKey(new NamespacedKey(key.split(":")[0], key.split(":")[1]));
        }
        for (NamespacedKey namespacedKey : this.zoneMap.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public Zone getZone(NamespacedKey key) {
        return this.zoneMap.get(key);
    }

    public Zone getZone(String namespace, String key) {
        return this.zoneMap.get(new NamespacedKey(namespace, key));
    }

    public Zone getZone(String key) {
        if (key.contains(":")) {
            return this.zoneMap.get(new NamespacedKey(key.split(":")[0], key.split(":")[1]));
        }
        for (NamespacedKey namespacedKey : this.zoneMap.keySet()) {
            if (!namespacedKey.getKey().equalsIgnoreCase(key)) continue;
            return this.zoneMap.get(namespacedKey);
        }
        return null;
    }

    private void clearCaches() {
        this.chunkMoveCheckCache.clear();
        this.locationZoneCache.clear();
        this.worldDistrictCache.clear();
        this.worldCache.clear();
    }

    protected void addCache(@NotNull Zone zone) {
        List keys = this.worldCache.getOrDefault(zone.getWorld(), new ArrayList());
        if (!keys.contains(zone.getKey())) {
            keys.add(zone.getKey());
        }
        if (this.worldCache.containsKey(zone.getWorld())) {
            this.worldCache.replace(zone.getWorld(), keys);
        } else {
            this.worldCache.put(zone.getWorld(), keys);
        }
        keys = this.worldDistrictCache.getOrDefault(zone.getDistrict(), new ArrayList());
        if (!keys.contains(zone.getKey())) {
            keys.add(zone.getKey());
        }
        if (this.worldDistrictCache.containsKey(zone.getDistrict())) {
            this.worldDistrictCache.replace(zone.getDistrict(), keys);
        } else {
            this.worldDistrictCache.put(zone.getDistrict(), keys);
        }
    }

    private void removeCache(Zone zone) {
        List keys = this.worldCache.getOrDefault(zone.getWorld(), new ArrayList());
        keys.remove(zone.getKey());
        if (this.worldCache.containsKey(zone.getWorld())) {
            this.worldCache.replace(zone.getWorld(), keys);
        }
        keys = this.worldDistrictCache.getOrDefault(zone.getDistrict(), new ArrayList());
        keys.remove(zone.getKey());
        if (this.worldDistrictCache.containsKey(zone.getDistrict())) {
            this.worldDistrictCache.replace(zone.getDistrict(), keys);
        }
    }

    public void scheduleSave() {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Guardian.getInstance(), this::save, 80L);
    }

    public void save() {
        File file = this.getStorageFile();
        FileManager.clear(file);
        JsonObject storage = new JsonObject();
        for (Zone zone : this.zoneMap.values()) {
            String key = zone.getKey().toString();
            JsonObject object = storage.has("key") ? storage.getAsJsonObject("key") : new JsonObject();
            zone.save(object);
            object.addProperty("class_loader", zone.getClass().getName());
            storage.add(key, (JsonElement)object);
        }
        if (this.config.compressData) {
            FileManager.writeCompressed(file, storage.toString());
        } else {
            FileManager.write(file, storage.toString());
        }
    }

    public void load() {
        File file = this.getStorageFile();
        String string = FileManager.readCompressed(file);
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        JsonObject storage = PARSER.parse(string).getAsJsonObject();
        for (Map.Entry entry : storage.entrySet()) {
            JsonObject object;
            JsonObject jsonObject = object = ((JsonElement)entry.getValue()).isJsonObject() ? ((JsonElement)entry.getValue()).getAsJsonObject() : new JsonObject();
            if (!object.has("class_loader")) continue;
            try {
                String namespace = ((String)entry.getKey()).split(":")[0];
                String key = ((String)entry.getKey()).split(":")[1];
                NamespacedKey namespacedKey = new NamespacedKey(namespace, key);
                Mirror mirror = Mirror.mirror(object.get("class_loader").getAsString());
                Zone zone = (Zone)mirror.constructor(NamespacedKey.class, JsonObject.class).newInstance(namespacedKey, object);
                zone.load(object);
                this.zoneMap.put(namespacedKey, zone);
                this.addCache(zone);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void reload() {
        this.clearCaches();
        this.load();
    }

    private File getStorageFile() {
        File file = new File("plugins/Guardian/", "zone_storage.cjs");
        FileManager.putIfAbsent(file);
        return file;
    }
}

