/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.gson.JsonObject;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.Child;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CuboidalChild
extends CuboidalZone
implements Child<CuboidalZone> {
    private GuardianAPI api;
    private BoundingBox boundingBox;
    private Location location;
    private UUID owner;
    private CuboidalZone parent;
    private String name = null;
    private String description = null;

    public CuboidalChild(@NotNull NamespacedKey id) {
        super(id);
        throw new IllegalArgumentException("This constructor may not be used!");
    }

    public CuboidalChild(@NotNull String id, @NotNull BoundingBox boundingBox, @NotNull World world) {
        super(Guardian.getNamespacedKey(id));
        throw new IllegalArgumentException("This constructor may not be used!");
    }

    public CuboidalChild(@NotNull String id, @NotNull BoundingBox boundingBox, @NotNull CuboidalZone parent) {
        super(Guardian.getNamespacedKey(id));
        this.boundingBox = boundingBox;
        this.location = boundingBox.getCenter().toLocation(parent.getWorld());
        this.api = Guardian.getApi();
    }

    public CuboidalChild(@NotNull NamespacedKey id, @NotNull JsonObject section) {
        super(id, section);
    }

    public static CuboidalChild createZone(Player player, String id, CuboidalZone parent, Location l1, Location l2) {
        BoundingBox boundingBox = BoundingBox.of((Location)l1, (Location)l2);
        CuboidalChild zone = new CuboidalChild(id, boundingBox, parent);
        zone.setOwner(player.getUniqueId());
        return zone;
    }

    public static CuboidalChild createZone(String id, CuboidalZone parent, Location l1, Location l2) {
        BoundingBox boundingBox = BoundingBox.of((Location)l1, (Location)l2);
        CuboidalChild zone = new CuboidalChild(id, boundingBox, parent);
        zone.setOwner(null);
        return zone;
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public <Z extends Zone> boolean overlaps(Z zone) {
        if (zone instanceof CuboidalChild) {
            return this.overlaps((CuboidalChild)zone);
        }
        return super.overlaps(zone);
    }

    public boolean overlaps(CuboidalChild cuboidalZone) {
        return cuboidalZone.getBoundingBox().overlaps(this.boundingBox);
    }

    public boolean eclipses(CuboidalChild cuboidalZone) {
        return this.overlaps(cuboidalZone) && this.boundingBox.contains(cuboidalZone.getBoundingBox());
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.parent.getOwner();
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.parent.setOwner(owner);
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public double getRadius() {
        return this.boundingBox.getMax().distance(this.boundingBox.getMin()) / 2.0 + 2.0;
    }

    @Override
    public boolean isInside(@NotNull Location location) {
        return location.getWorld() == this.getWorld() && this.boundingBox.clone().expand(0.1, 0.1, 0.1).contains(location.toVector());
    }

    @Override
    public boolean canEdit(@NotNull UUID player) {
        return player.equals(this.getOwner()) || Bukkit.getOfflinePlayer((UUID)player).isOp();
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void showBounds() {
        this.api.displayBox(this.getBoundingBox().clone().expand(0.05, 0.05, 0.05), this.getWorld(), null);
    }

    @Override
    public void save(@NotNull JsonObject section) {
        super.save(section);
    }

    @Override
    public void load(@NotNull JsonObject section) {
        super.load(section);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String s) {
        this.description = s;
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public CuboidalZone getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@NotNull CuboidalZone parent) {
        this.parent = parent;
    }
}

