/*
 * Decompiled with CFR 0.152.
 */
package dev.moderocky.mirror.functional;

import dev.moderocky.mirror.FieldMirror;
import dev.moderocky.mirror.Mirror;
import dev.moderocky.mirror.functional.StateMirror;

public abstract class ObjectStateMirror<T>
extends StateMirror<T> {
    private final T object;
    private final Mirror<T> mirror;
    private final boolean error;

    public ObjectStateMirror(T target) {
        this.object = target;
        this.mirror = new Mirror<T>(target);
        this.error = false;
        this.readFields();
    }

    public ObjectStateMirror(T target, boolean throwErrors) {
        this.object = target;
        this.mirror = new Mirror<T>(target);
        this.error = throwErrors;
        this.readFields();
    }

    @Override
    public final void readFields() {
        Mirror<ObjectStateMirror> thing = new Mirror<ObjectStateMirror>(this);
        for (FieldMirror field : thing.getFieldMirrors()) {
            try {
                this.mirror.ifHasField(field.getName(), fieldMirror -> field.set(fieldMirror.get()));
            }
            catch (Throwable throwable) {
                if (!this.error) continue;
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public final void writeFields() {
        Mirror<ObjectStateMirror> thing = new Mirror<ObjectStateMirror>(this);
        for (FieldMirror field : thing.getFieldMirrors()) {
            field.ifHasMatching(this.mirror, fieldMirror -> fieldMirror.set(field.get()));
        }
    }

    @Override
    public final T getTarget() {
        return this.object;
    }

    @Override
    public final Mirror<T> getMirror() {
        return this.mirror;
    }
}

