/*
 * Decompiled with CFR 0.152.
 */
package dev.moderocky.mirror.functional;

import dev.moderocky.mirror.FieldMirror;
import dev.moderocky.mirror.Mirror;
import dev.moderocky.mirror.functional.StateMirror;

public abstract class ClassStateMirror<T>
extends StateMirror<Class<T>> {
    private final Class<T> cls;
    private final Mirror<Class<T>> mirror;
    private final boolean error;

    public ClassStateMirror(Class<T> cls) {
        this.cls = cls;
        this.mirror = new Mirror<Class<Class<T>>>(cls);
        this.error = false;
        this.readFields();
    }

    public ClassStateMirror(Class<T> cls, boolean throwErrors) {
        this.cls = cls;
        this.mirror = new Mirror<Class<Class<T>>>(cls);
        this.error = throwErrors;
        this.readFields();
    }

    public final T construct(Object ... params) {
        return (T)this.mirror.tryCatchFunc(classIMirror -> this.mirror.instantiate(params), null);
    }

    @Override
    public final void readFields() {
        Mirror<ClassStateMirror> thing = new Mirror<ClassStateMirror>(this);
        for (FieldMirror field : thing.getFieldMirrors()) {
            try {
                this.mirror.ifHasField(field.getName(), fieldMirror -> field.set(fieldMirror.get()));
            }
            catch (Throwable throwable) {
                if (!this.error) continue;
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public final void writeFields() {
        Mirror<ClassStateMirror> thing = new Mirror<ClassStateMirror>(this);
        for (FieldMirror field : thing.getFieldMirrors()) {
            try {
                this.mirror.ifHasField(field.getName(), fieldMirror -> fieldMirror.set(field.get()));
            }
            catch (Throwable throwable) {
                if (!this.error) continue;
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public final Class<T> getTarget() {
        return this.cls;
    }

    @Override
    public final Mirror<Class<T>> getMirror() {
        return this.mirror;
    }
}

