/*
 * Decompiled with CFR 0.152.
 */
package dev.moderocky.mask.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.moderocky.guardian.mask.annotation.Unsafe;
import dev.moderocky.mask.configuration.Configuration;
import dev.moderocky.mask.configuration.EntrySection;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JsonEntrySection
extends Configuration {
    private final JsonObject object;

    public JsonEntrySection(JsonObject object) {
        this.object = object;
    }

    private JsonElement getAsElement(Object object) {
        if (object instanceof String) {
            return new JsonPrimitive(object.toString());
        }
        if (object instanceof Number) {
            return new JsonPrimitive((Number)object);
        }
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(object.toString());
    }

    private Object getAsJavaObject(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isString()) {
                return element.getAsString();
            }
            if (element.getAsJsonPrimitive().isBoolean()) {
                return element.getAsBoolean();
            }
            if (element.getAsJsonPrimitive().isNumber()) {
                return element.getAsNumber();
            }
        }
        if (element.isJsonArray()) {
            return this.classParse(List.class, element);
        }
        return null;
    }

    @Unsafe
    private <T> T classParse(Class<T> clarse, JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (clarse.isAssignableFrom(Collection.class) || element.isJsonArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            JsonArray array = element.getAsJsonArray();
            for (JsonElement json : array) {
                list.add(this.getAsJavaObject(json));
            }
            return (T)list;
        }
        if (element.isJsonPrimitive()) {
            if (clarse.equals(String.class) || clarse.isAssignableFrom(String.class)) {
                return (T)element.getAsString();
            }
            if (clarse.equals(Character.class) || clarse.isAssignableFrom(Character.class)) {
                return (T)Character.valueOf(element.getAsCharacter());
            }
            if (clarse.equals(Boolean.class) || clarse.isAssignableFrom(Boolean.class)) {
                return (T)Boolean.valueOf(element.getAsBoolean());
            }
            if (clarse.equals(Byte.class) || clarse.isAssignableFrom(Byte.class)) {
                return (T)Byte.valueOf(element.getAsByte());
            }
            if (clarse.equals(BigDecimal.class) || clarse.isAssignableFrom(BigDecimal.class)) {
                return (T)element.getAsBigDecimal();
            }
            if (clarse.equals(BigInteger.class) || clarse.isAssignableFrom(BigInteger.class)) {
                return (T)element.getAsBigInteger();
            }
            if (clarse.equals(Integer.class) || clarse.isAssignableFrom(Integer.class)) {
                return (T)Integer.valueOf(element.getAsInt());
            }
            if (clarse.equals(Float.class) || clarse.isAssignableFrom(Float.class)) {
                return (T)Float.valueOf(element.getAsFloat());
            }
            if (clarse.equals(Double.class) || clarse.isAssignableFrom(Double.class)) {
                return (T)Double.valueOf(element.getAsDouble());
            }
            if (clarse.equals(Long.class) || clarse.isAssignableFrom(Long.class)) {
                return (T)Long.valueOf(element.getAsLong());
            }
            if (clarse.equals(Short.class) || clarse.isAssignableFrom(Short.class)) {
                return (T)Short.valueOf(element.getAsShort());
            }
            if (clarse.equals(Number.class) || clarse.isAssignableFrom(Number.class)) {
                return (T)element.getAsNumber();
            }
        } else if (element.isJsonNull()) {
            if (clarse.equals(Void.class) || clarse.isAssignableFrom(Void.class)) {
                return (T)element.getAsJsonNull();
            }
            if (clarse.equals(JsonNull.class) || clarse.isAssignableFrom(JsonNull.class)) {
                return (T)element.getAsJsonNull();
            }
        }
        return (T)element.getAsJsonObject();
    }

    @Override
    public void set(String key, Object entry) {
        this.object.add(key, this.getAsElement(entry));
    }

    @Override
    public void set(String key, Collection<?> collection) {
        JsonArray array = new JsonArray();
        for (Object o : collection) {
            array.add(this.getAsElement(o));
        }
        this.object.add(key, (JsonElement)array);
    }

    @Override
    public void set(String key, Map<String, Object> map) {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            json.add(entry.getKey(), this.getAsElement(entry.getValue()));
        }
        this.object.add(key, (JsonElement)json);
    }

    @Override
    public boolean hasEntry(String key) {
        return this.object.has(key);
    }

    @Override
    public Class<?> getEntryType(String key) {
        if (!this.hasEntry(key)) {
            return null;
        }
        JsonElement element = this.object.get(key);
        if (element.isJsonNull()) {
            return Void.class;
        }
        if (element.isJsonPrimitive()) {
            if (element.getAsJsonPrimitive().isBoolean()) {
                return Boolean.class;
            }
            if (element.getAsJsonPrimitive().isString()) {
                return String.class;
            }
            if (element.getAsJsonPrimitive().isNumber()) {
                return Number.class;
            }
        } else {
            if (element.isJsonArray()) {
                return Collection.class;
            }
            if (element.isJsonObject()) {
                return EntrySection.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getLiteral(String key) {
        return this.object.get(key);
    }

    @Override
    public <T> T getAs(String key, Class<T> clarse) {
        try {
            return this.classParse(clarse, this.object.get(key));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public String getString(String key) {
        return this.object.get(key).getAsString();
    }

    @Override
    public int getInt(String key) {
        return this.object.get(key).getAsInt();
    }

    @Override
    public double getDouble(String key) {
        return this.object.get(key).getAsDouble();
    }

    @Override
    public float getFloat(String key) {
        return this.object.get(key).getAsFloat();
    }

    @Override
    public long getLong(String key) {
        return this.object.get(key).getAsLong();
    }

    @Override
    public short getShort(String key) {
        return this.object.get(key).getAsShort();
    }

    @Override
    public char getChar(String key) {
        return this.object.get(key).getAsCharacter();
    }

    @Override
    public boolean getBoolean(String key) {
        return this.object.get(key).getAsBoolean();
    }

    @Override
    public byte getByte(String key) {
        return this.object.get(key).getAsByte();
    }

    @Override
    @NotNull
    public List<String> getStringList(String key) {
        if (!this.object.has(key)) {
            return new ArrayList<String>();
        }
        JsonArray array = this.object.get(key).getAsJsonArray();
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : array) {
            try {
                list.add(element.getAsString());
            }
            catch (Throwable throwable) {}
        }
        return list;
    }

    @Override
    @NotNull
    public <T> List<T> getList(String key, Class<T> clarse) {
        if (!this.object.has(key)) {
            return new ArrayList();
        }
        JsonArray array = this.object.get(key).getAsJsonArray();
        ArrayList<T> list = new ArrayList<T>();
        for (JsonElement element : array) {
            try {
                list.add(this.classParse(clarse, element));
            }
            catch (Throwable throwable) {}
        }
        return list;
    }

    @Override
    @NotNull
    public <T> List<T> addToList(String key, List<T> list, Class<T> clarse) {
        list.addAll(this.getList(key, clarse));
        return list;
    }

    @Override
    public EntrySection getSection(String key) {
        return new JsonEntrySection(this.object.get(key).getAsJsonObject());
    }

    @Override
    public boolean hasSection(String key) {
        return this.object.has(key) && this.object.get(key).isJsonObject();
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.object.entrySet().forEach(entry -> keys.add((String)entry.getKey()));
        return keys;
    }

    @Override
    public Collection<String> getKeys(boolean deep) {
        return this.getKeys();
    }

    @Override
    public Map<String, Object> getAsMap() {
        return null;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> map) {
        return null;
    }

    @Override
    public boolean writeFrom(Map<String, Object> map) {
        return false;
    }
}

