/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="All Guardian Zones")
@Description(value={"Returns all Guardian zones ", "This might be useful for listing. ", "These zones are returned as strings, bearing the full ID.", "In most cases, this will be 'guardian:zone_id_here' - to preserve compatibility."})
@Examples(value={"set {_zones::*} to all guardian zones"})
@Since(value="1.1.0")
public class ZonesExpr
extends SimpleExpression<String> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected String[] get(@NotNull Event event) {
        GuardianAPI api = Guardian.getApi();
        List<Zone> zones = api.getZones();
        if (zones.isEmpty()) {
            return new String[0];
        }
        ArrayList strings = new ArrayList();
        zones.forEach(zone -> strings.add(zone.getKey().toString()));
        return strings.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "all guardian zones";
    }

    static {
        Skript.registerExpression(ZonesExpr.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"all [guardian] zones"});
    }
}

