/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Zones at Location")
@Description(value={"Returns all Guardian zones at the location/entity/block. ", "This might be useful for testing what protections should be applied (if you are using custom flags.) ", "These zones are returned as strings, bearing the full ID.", "In most cases, this will be 'guardian:zone_id_here' - to preserve compatibility."})
@Examples(value={"set {_zones::*} to the guardian zones at player", "set {_zones::*} to zones at target block", "set {_zones::*} to all zones at {_loc}"})
@Since(value="1.0.4")
public class ZonesAtLocationExpr
extends SimpleExpression<String> {
    private Expression<Location> locationExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.locationExpression = exprs[0];
        return true;
    }

    protected String[] get(@NotNull Event event) {
        Location location = (Location)this.locationExpression.getSingle(event);
        if (location == null) {
            return new String[0];
        }
        GuardianAPI api = Guardian.getApi();
        List<Zone> zones = api.getZones(location);
        if (zones.isEmpty()) {
            return new String[0];
        }
        ArrayList strings = new ArrayList();
        zones.forEach(zone -> strings.add(zone.getKey().toString()));
        return strings.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.locationExpression != null) {
            string = this.locationExpression.toString(event, debug);
        }
        return "zones at " + string;
    }

    static {
        Skript.registerExpression(ZonesAtLocationExpr.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"([the|all]) [guardian] zones at %location%"});
    }
}

