/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.PolyhedralZone;
import com.moderocky.guardian.api.Zone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Owner of Zone")
@Description(value={"Accesses the owner of a Guardian zone. "})
@Examples(value={"set the owner of zone \"my_zone\" to player", "set {_p} to zone \"my_zone\"'s owner", "delete zone \"my_zone\"'s owner"})
@Since(value="1.0.5")
public class ZoneOwnerExpr
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> stringExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected OfflinePlayer[] get(@NotNull Event event) {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return new OfflinePlayer[0];
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return new OfflinePlayer[0];
        }
        Zone zone = api.getZone(id);
        ArrayList players = new ArrayList();
        zone.getAllowedPlayers().forEach(uuid -> players.add(Bukkit.getOfflinePlayer((UUID)uuid)));
        return players.toArray(new OfflinePlayer[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case DELETE: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class, OfflinePlayer.class});
            }
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] objects, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) throws UnsupportedOperationException {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return;
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return;
        }
        Zone zone = api.getZone(id);
        OfflinePlayer[] players = objects == null ? null : (OfflinePlayer[])Arrays.copyOf(objects, objects.length, OfflinePlayer[].class);
        switch (mode) {
            case SET: {
                if (players == null || players.length == 0) break;
                if (zone instanceof CuboidalZone) {
                    ((CuboidalZone)zone).setOwner(players[0].getUniqueId());
                    break;
                }
                if (!(zone instanceof PolyhedralZone)) break;
                ((PolyhedralZone)zone).setOwner(players[0].getUniqueId());
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case RESET: {
                break;
            }
            case DELETE: {
                if (zone instanceof CuboidalZone) {
                    ((CuboidalZone)zone).setOwner(null);
                    break;
                }
                if (!(zone instanceof PolyhedralZone)) break;
                ((PolyhedralZone)zone).setOwner(null);
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "owner of zone " + string;
    }

    static {
        Skript.registerExpression(ZoneOwnerExpr.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] owner of [guardian] zone %string%", "[guardian] zone %string%'s owner"});
    }
}

