/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Allowed Players of Zone")
@Description(value={"Accesses the allowed players of a Guardian zone. "})
@Examples(value={"add player to the allowed players of zone \"my_zone\"", "add player and target player to the allowed players of zone \"my_zone\"", "add {some_players::*} to guardian zone \"my_zone\"'s allowed players", "reset zone \"my_zone\"'s allowed players", "set guardian zone \"my_zone\"'s allowed players to {list_of_players::*}"})
@Since(value="1.0.5")
public class ZoneAccessorsExpr
extends SimpleExpression<OfflinePlayer> {
    private Expression<String> stringExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected OfflinePlayer[] get(@NotNull Event event) {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return new OfflinePlayer[0];
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return new OfflinePlayer[0];
        }
        Zone zone = api.getZone(id);
        ArrayList players = new ArrayList();
        zone.getAllowedPlayers().forEach(uuid -> players.add(Bukkit.getOfflinePlayer((UUID)uuid)));
        return players.toArray(new OfflinePlayer[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer[].class});
    }

    public void change(@NotNull Event event, @Nullable Object[] objects, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) throws UnsupportedOperationException {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return;
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return;
        }
        Zone zone = api.getZone(id);
        OfflinePlayer[] players = objects == null ? null : (OfflinePlayer[])Arrays.copyOf(objects, objects.length, OfflinePlayer[].class);
        switch (mode) {
            case SET: {
                if (players == null) break;
                zone.getAllowedPlayers().forEach(zone::removePlayer);
                for (OfflinePlayer player : players) {
                    if (zone.isAllowed(player.getUniqueId())) continue;
                    zone.addPlayer(player.getUniqueId());
                }
                break;
            }
            case ADD: {
                if (players == null) break;
                for (OfflinePlayer player : players) {
                    if (zone.isAllowed(player.getUniqueId())) continue;
                    zone.addPlayer(player.getUniqueId());
                }
                break;
            }
            case DELETE: {
                zone.clearPlayers();
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                if (players == null) break;
                for (OfflinePlayer player : players) {
                    zone.removePlayer(player.getUniqueId());
                }
                break;
            }
            case RESET: {
                zone.clearPlayers();
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "allowed players of zone " + string;
    }

    static {
        Skript.registerExpression(ZoneAccessorsExpr.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] allowed players of [guardian] zone %string%", "[guardian] zone %string%'s allowed players"});
    }
}

