/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

@Name(value="Register Guardian Flag")
@Description(value={"Register a new Guardian protection flag. ", "Flags used by Guardian are togglable protections for zones. ", "You will have to supplement the flag behaviour for yourself. "})
@Examples(value={"register new protection flag \"my_cool_flag\"", "register new protection flag \"no_guns_allowed\""})
@Since(value="1.0.4")
public class RegisterFlagEffect
extends Effect {
    private Expression<String> stringExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected void execute(@NotNull Event event) {
        if (this.stringExpression == null) {
            return;
        }
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return;
        }
        id = id.replace(" ", "_").toLowerCase().replaceAll("([^a-z0-9_-]+)", "_");
        while (id.contains("__")) {
            id = id.replace("__", "_");
        }
        GuardianAPI api = Guardian.getApi();
        if (api.getProtectionFlags().contains(id)) {
            return;
        }
        api.addProtectionFlag(id, PermissionDefault.OP);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "register new protection flag " + string;
    }

    static {
        Skript.registerEffect(RegisterFlagEffect.class, (String[])new String[]{"register [a] new [guardian] protection flag %string%"});
    }
}

