/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.template;

import com.google.common.base.CaseFormat;
import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.annotation.Configurable;
import com.moderocky.guardian.mask.api.Parser;
import com.moderocky.guardian.mask.internal.utility.FileManager;
import com.moderocky.guardian.mask.mirror.FieldMirror;
import com.moderocky.guardian.mask.mirror.Mirror;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public interface Config {
    default public void save() {
        File file = this.getFile();
        FileConfiguration config = this.getConfig();
        Mirror<Config> mirror = new Mirror<Config>(this);
        mirror.ifHasAnnotation(Configurable.Overwrite.class, overwrite -> {
            if (overwrite.value()) {
                FileManager.write(file, "");
            }
        });
        HashMap<String, String[]> comments = new HashMap<String, String[]>();
        for (FieldMirror<?> field : mirror.getFieldMirrors(Configurable.class)) {
            Object value;
            if (field.isTransient()) continue;
            Configurable configurable = field.getAnnotation(Configurable.class);
            String path = this.getFieldPath(field.getLiteral(), configurable.value());
            if (field.isPrimitive()) {
                value = field.get();
            } else if (field.isArray()) {
                Object[] objects;
                ArrayList<String> list = new ArrayList<String>();
                for (Object object : objects = (Object[])field.get()) {
                    list.add(object.toString());
                }
                value = list;
            } else if (field.isCollection()) {
                value = field.get();
            } else if (field.isEnum()) {
                value = field.get().toString();
            } else if (field.isMap()) {
                value = null;
                for (Map.Entry entry : ((Map)field.get()).entrySet()) {
                    try {
                        config.set(path + "." + entry.getKey().toString(), entry.getValue());
                    }
                    catch (Throwable throwable) {
                        Bukkit.getLogger().log(Level.WARNING, "Config saving error: " + entry.getValue().toString() + " could not be stored.");
                    }
                }
            } else {
                value = this.serialise(field.getLiteral(), field.get());
            }
            if (value != null) {
                config.set(path, value);
            }
            field.ifHasAnnotation(Configurable.Comment.class, comment -> {
                if (comment.value().length < 1) {
                    return;
                }
                comments.put(path.toLowerCase(), comment.value());
            });
        }
        FileManager.save(config, file);
        this.addComments(comments);
    }

    default public Config load() {
        FileConfiguration config = this.getConfig();
        Mirror<Config> mirror = new Mirror<Config>(this);
        for (FieldMirror<?> field : mirror.getFieldMirrors(Configurable.class)) {
            Configurable configurable = field.getAnnotation(Configurable.class);
            if (configurable.override()) continue;
            String path = this.getFieldPath(field.getLiteral(), configurable.value());
            if (field.isMap()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section == null || section.getKeys(false).size() <= 0) continue;
                for (String key : section.getKeys(false)) {
                    try {
                        map.put(key, section.get(key));
                    }
                    catch (Throwable throwable) {
                        Bukkit.getLogger().log(Level.WARNING, "Config loading error: " + section.get(key).toString() + " could not be loaded.");
                    }
                }
                field.set(this, map);
                continue;
            }
            if (!config.isSet(path)) continue;
            Object value = field.isEnum() ? new Mirror(field.getType()).getEnum(config.getString(path).toUpperCase().replace(" ", "_")) : (config.get(path) instanceof String ? this.matchString(field.getLiteral(), config.get(path)) : this.adjustValue(field.getLiteral(), config.get(path)));
            value = this.deserialise(field.getLiteral(), value);
            field.set(value);
        }
        this.save();
        return this;
    }

    default public Object serialise(Field field, Object value) {
        Configurable.Serialise serialise = field.getAnnotation(Configurable.Serialise.class);
        if (serialise == null || !serialise.stringify()) {
            return value;
        }
        return value.toString();
    }

    default public Object deserialise(Field field, Object value) {
        Mirror<Field> mirror = new Mirror<Field>(field);
        if (!mirror.hasAnnotation(Configurable.Serialise.class)) {
            return value;
        }
        Configurable.Serialise serialise = mirror.getAnnotation(Configurable.Serialise.class);
        return mirror.hasMethod(serialise.method(), value.getClass()) ? mirror.invoke(serialise.method(), value) : value.toString();
    }

    default public void addComments(@NotNull HashMap<String, String[]> comments) {
    }

    default public Object matchString(Field field, Object value) {
        Configurable.Regex matcher = field.getAnnotation(Configurable.Regex.class);
        if (matcher == null) {
            return value;
        }
        String v = (String)value;
        String regex = matcher.matcher();
        if (v.matches(regex)) {
            return value;
        }
        return matcher.alternative();
    }

    default public Object adjustValue(Field field, Object value) {
        Configurable.Bounded bounded = field.getAnnotation(Configurable.Bounded.class);
        if (bounded == null) {
            return value;
        }
        if (value instanceof Integer) {
            int v = (Integer)value;
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (int)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (int)Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Long) {
            long v = (Long)value;
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (long)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (long)Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Double) {
            double v = (Double)value;
            if (v > bounded.maxValue()) {
                v = Math.min(v, Math.floor(bounded.maxValue()));
            }
            if (v > bounded.minValue()) {
                v = Math.max(v, Math.floor(bounded.minValue()));
            }
            value = v;
        } else if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if ((double)v > bounded.maxValue()) {
                v = Math.min(v, (float)Math.floor(bounded.maxValue()));
            }
            if ((double)v > bounded.minValue()) {
                v = Math.max(v, (float)Math.floor(bounded.minValue()));
            }
            value = Float.valueOf(v);
        }
        return value;
    }

    default public String convertFieldName(Field field) {
        String fieldName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
        try {
            Configurable.Keyed keyed = field.getAnnotation(Configurable.Keyed.class);
            if (keyed != null && keyed.value().length() > 0 && keyed.value().matches("^[a-zA-Z0-9_-]+$")) {
                fieldName = keyed.value();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldName;
    }

    default public String getFieldPath(Field field, String parent) {
        String path;
        String fieldName = this.convertFieldName(field);
        if (parent.length() > 0) {
            path = parent;
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            path = path + fieldName;
        } else {
            path = fieldName;
        }
        return path.replaceAll("\\.\\.", ".");
    }

    default public <T> T parse(String string, Parser<T> parser) {
        return parser.parse(string);
    }

    @API
    @NotNull
    public String getFolderPath();

    @API
    @NotNull
    public String getFileName();

    default public FileConfiguration getConfig() {
        return FileManager.getFile(this.getFolderPath(), this.getFileName());
    }

    default public File getFile() {
        return new File(this.getFolderPath(), this.getFileName());
    }
}

