/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.template;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.moderocky.guardian.mask.Mask;
import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.annotation.Internal;
import com.moderocky.guardian.mask.annotation.Unsafe;
import com.moderocky.guardian.mask.api.MagicList;
import com.moderocky.guardian.mask.bstats.bukkit.Metrics;
import com.moderocky.guardian.mask.gui.MenuGUI;
import com.moderocky.guardian.mask.mirror.Mirror;
import com.moderocky.guardian.mask.template.CompleteCommand;
import com.moderocky.guardian.mask.template.CompleteRecipe;
import com.moderocky.guardian.mask.template.IPlugin;
import com.moderocky.guardian.mask.template.Listener;
import com.moderocky.guardian.mask.template.WrappedCommand;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;

@API
public abstract class BukkitPlugin
extends JavaPlugin
implements IPlugin {
    private static BukkitPlugin instance;
    private final Metrics maskMetrics = new Metrics((Plugin)this, 6786);
    private SkriptAddon addon;
    private CommandMap commandMap = null;

    public BukkitPlugin() {
    }

    protected BukkitPlugin(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description, dataFolder, file);
    }

    @API
    public static <T extends BukkitPlugin> T getInstance() {
        return (T)instance;
    }

    @Unsafe
    @Internal
    protected void setInstance(@Nullable BukkitPlugin plugin) {
        instance = plugin;
    }

    @API
    public static <Z extends Event> void callEvent(Z event) {
        Bukkit.getScheduler().runTask(BukkitPlugin.getInstance(), () -> Bukkit.getServer().getPluginManager().callEvent(event));
    }

    @API
    public static FixedMetadataValue getMetaValue(Object object) {
        return new FixedMetadataValue(BukkitPlugin.getInstance(), object);
    }

    @API
    public static NamespacedKey getNamespacedKey(String string) {
        return new NamespacedKey(BukkitPlugin.getInstance(), string);
    }

    public static boolean isPaper() {
        try {
            Class.forName("co.aikar.timings.Timing");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @API
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @API
    public String getAPIVersion() {
        return this.getDescription().getAPIVersion();
    }

    @API
    public String getPluginDescription() {
        return this.getDescription().getDescription();
    }

    @API
    public String getFullName() {
        return this.getDescription().getFullName();
    }

    @API
    public String getPrefix() {
        return this.getDescription().getPrefix();
    }

    @API
    public boolean areDependenciesMet() {
        if (this.getDescription().getSoftDepend().size() > 0) {
            for (String string : this.getDescription().getSoftDepend()) {
                if (Bukkit.getPluginManager().getPlugin(string) != null) continue;
                return false;
            }
        }
        return true;
    }

    @API
    public String getCraftVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    @API
    public void disablePlugin() {
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    @Internal
    public void onEnable() {
        this.setInstance(this);
        this.registerMask();
        this.registerAddon();
        this.startup();
        this.registerManagers();
        this.registerProtocol();
        this.registerListeners();
        this.registerRecipes();
        this.registerEvents();
        this.registerCommands();
        if (Mask.getMask().hasSkript()) {
            this.registerSyntax();
        }
    }

    @Internal
    public void onDisable() {
        this.disable();
        this.setInstance(null);
        this.unregisterMask();
    }

    @API
    public SkriptAddon getAddon() {
        return this.addon;
    }

    @Internal
    private void unregisterMask() {
        Mask.setMask(null, null);
    }

    @Internal
    private void registerMask() {
        Mask.setMask(new Mask(), this);
    }

    @Internal
    private void registerAddon() {
        this.addon = Mask.getMask().hasSkript() ? Skript.registerAddon((JavaPlugin)this) : null;
    }

    @Override
    @API
    public String getConfigPath() {
        return "plugins/" + this.getName() + "/config.yml";
    }

    @API
    public void resetConfig() {
    }

    @API
    protected void register(WrappedCommand ... commands) {
        for (WrappedCommand command : commands) {
            try {
                Constructor commandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                if (!commandConstructor.isAccessible()) {
                    commandConstructor.setAccessible(true);
                }
                PluginCommand pluginCommand = (PluginCommand)commandConstructor.newInstance(command.getCommand(), BukkitPlugin.getInstance());
                pluginCommand.setAliases(command.getAliases());
                pluginCommand.setDescription(command.getDescription());
                pluginCommand.setPermission(command.getPermission());
                pluginCommand.setPermissionMessage(command.getPermissionMessage());
                pluginCommand.setUsage(command.getUsage());
                pluginCommand.register(this.getCommandMap());
                if (this.getCommandMap().register(command.getCommand(), this.getName(), (Command)pluginCommand)) {
                    pluginCommand.setExecutor((CommandExecutor)command);
                    pluginCommand.setTabCompleter((TabCompleter)command);
                    continue;
                }
                Command com = this.getCommandMap().getCommand(pluginCommand.getName());
                if (com instanceof PluginCommand) {
                    ((PluginCommand)com).setExecutor((CommandExecutor)command);
                    ((PluginCommand)com).setTabCompleter((TabCompleter)command);
                }
                Bukkit.getLogger().log(Level.WARNING, "A command '/" + command.getCommand() + "' is already defined!");
                Bukkit.getLogger().log(Level.WARNING, "As this cannot be replaced, the executor will be overridden.");
                Bukkit.getLogger().log(Level.WARNING, "To avoid this warning, please do not add WrappedCommands to your plugin.yml.");
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isRegistered(CompleteCommand command) {
        return this.getCommand(command.getCommand()) != null;
    }

    protected boolean isRegistered(String command) {
        return this.getCommand(command) != null;
    }

    @API
    protected void register(CompleteCommand ... commands) {
        if (commands == null) {
            return;
        }
        for (CompleteCommand completeCommand : commands) {
            PluginCommand pluginCommand = this.getCommand(completeCommand.getCommand());
            if (pluginCommand == null) {
                return;
            }
            pluginCommand.setExecutor((CommandExecutor)completeCommand);
        }
    }

    @API
    protected void register(MenuGUI ... guis) {
        for (MenuGUI gui : guis) {
            Bukkit.getServer().getPluginManager().registerEvents((org.bukkit.event.Listener)gui, BukkitPlugin.getInstance());
        }
    }

    @API
    protected void register(org.bukkit.event.Listener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (org.bukkit.event.Listener listener : listeners) {
            Bukkit.getServer().getPluginManager().registerEvents(listener, BukkitPlugin.getInstance());
        }
    }

    @API
    protected void register(CompleteRecipe ... recipes) {
        if (recipes == null) {
            return;
        }
        for (CompleteRecipe completeRecipe : recipes) {
            if (!completeRecipe.isEnabled()) continue;
            Bukkit.addRecipe((Recipe)completeRecipe.getRecipe());
        }
    }

    @API
    protected org.bukkit.event.Listener[] register(Listener<?> ... listeners) {
        PluginManager manager = Bukkit.getServer().getPluginManager();
        MagicList list = new MagicList();
        for (Listener<?> listener : listeners) {
            list.add(this.register(listener));
        }
        return (org.bukkit.event.Listener[])list.toArray();
    }

    @API
    protected org.bukkit.event.Listener[] register(long lifetime, Listener<?> ... listeners) {
        PluginManager manager = Bukkit.getServer().getPluginManager();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> Arrays.asList(listeners).forEach(HandlerList::unregisterAll), lifetime);
        return listeners;
    }

    @API
    protected org.bukkit.event.Listener register(Listener<?> listener) {
        PluginManager manager = Bukkit.getServer().getPluginManager();
        manager.registerEvents(listener, BukkitPlugin.getInstance());
        return listener;
    }

    @API
    protected org.bukkit.event.Listener register(Listener<?> listener, long lifetime) {
        PluginManager manager = Bukkit.getServer().getPluginManager();
        ClosedListener<?> thing = this.createListener(listener);
        manager.registerEvents(thing, BukkitPlugin.getInstance());
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> HandlerList.unregisterAll((org.bukkit.event.Listener)thing), lifetime);
        return thing;
    }

    private <T extends Event> ClosedListener<T> createListener(Listener<T> listener) {
        return listener::event;
    }

    @API
    protected void registerRecipes() {
    }

    @API
    protected void registerListeners() {
    }

    @API
    protected void registerCommands() {
    }

    @API
    protected void registerManagers() {
    }

    @API
    protected void registerProtocol() {
    }

    @API
    protected void registerSyntax() {
    }

    @API
    protected void registerEvents() {
    }

    private final CommandMap getCommandMap() {
        if (this.commandMap == null) {
            this.commandMap = (CommandMap)new Mirror<Server>(Bukkit.getServer()).field("commandMap").get();
        }
        return this.commandMap;
    }

    @FunctionalInterface
    public static interface ClosedListener<T extends Event>
    extends org.bukkit.event.Listener {
        @EventHandler
        public void onEvent(T var1);
    }
}

