/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.gui;

import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.gui.InventoryGUI;
import com.moderocky.guardian.mask.template.CompleteListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@API
public class VisualGUI
implements InventoryGUI,
CompleteListener {
    protected final Inventory inventory;
    protected final List<Player> players = new ArrayList<Player>();
    protected final TreeMap<Integer, BiConsumer<Player, InventoryClickEvent>> map = new TreeMap();
    protected final HashMap<Character, ItemStack> layoutMap = new HashMap();
    protected final boolean editable;
    protected final Plugin plugin;
    protected final List<Consumer<?>> preActionConsumers = new ArrayList();
    protected boolean finished = false;
    protected String[] layout = new String[0];

    public VisualGUI(Plugin plugin, InventoryType type, String title) {
        this.plugin = plugin;
        if (!type.isCreatable()) {
            throw new IllegalArgumentException();
        }
        this.inventory = Bukkit.createInventory(null, (InventoryType)type, (String)title);
        this.editable = false;
    }

    public VisualGUI(Plugin plugin, int size, String title) {
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.editable = false;
    }

    public String[] getLayout() {
        return this.layout;
    }

    public VisualGUI setLayout(String[] layout) {
        if (!this.finished) {
            this.layout = layout;
        }
        return this;
    }

    @NotNull
    public ItemStack getReference(char ch) {
        return this.layoutMap.getOrDefault(Character.valueOf(ch), new ItemStack(Material.AIR));
    }

    public int[] getSlots(char ch) {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        char[] chars = String.join((CharSequence)"", this.layout).toCharArray();
        int n = 0;
        for (char c : chars) {
            if (c == ch) {
                integers.add(n);
            }
            ++n;
        }
        int[] ints = new int[integers.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)integers.get(i);
        }
        return ints;
    }

    private void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public int getSize() {
        return this.inventory.getSize();
    }

    public VisualGUI createButton(char ch, @NotNull ItemStack itemStack, @NotNull BiConsumer<Player, InventoryClickEvent> consumer) {
        this.preActionConsumers.add(o -> {
            for (int slot : this.getSlots(ch)) {
                this.map.put(Math.max(0, Math.min(this.inventory.getSize(), slot)), consumer);
                this.inventory.setItem(Math.max(0, Math.min(this.inventory.getSize(), slot)), itemStack);
            }
        });
        return this;
    }

    public VisualGUI createTile(char ch, ItemStack itemStack, boolean stealable) {
        this.preActionConsumers.add(o -> {
            BiConsumer<Player, InventoryClickEvent> consumer = (player, event) -> event.setCancelled(!stealable);
            for (int slot : this.getSlots(ch)) {
                this.map.put(Math.max(0, Math.min(this.inventory.getSize(), slot)), consumer);
                this.inventory.setItem(Math.max(0, Math.min(this.inventory.getSize(), slot)), itemStack);
            }
        });
        return this;
    }

    public VisualGUI createTile(char ch, @NotNull ItemStack itemStack) {
        this.layoutMap.put(Character.valueOf(ch), itemStack);
        this.preActionConsumers.add(o -> {
            for (int slot : this.getSlots(ch)) {
                this.inventory.setItem(Math.max(0, Math.min(this.inventory.getSize(), slot)), itemStack);
            }
        });
        return this;
    }

    public void finalise() {
        this.map.clear();
        this.inventory.clear();
        for (Consumer<?> consumer : this.preActionConsumers) {
            consumer.accept(null);
        }
        this.finished = true;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void open(Player player) {
        if (!this.finished) {
            this.finalise();
        }
        if (!this.hasListener()) {
            this.register();
        }
        player.openInventory(this.inventory);
        this.players.add(player);
    }

    @Override
    public boolean isOpen(Player player) {
        return this.players.contains(player);
    }

    @Override
    public InventoryType getType() {
        return this.inventory.getType();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.players.isEmpty()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.players.contains(player)) {
            return;
        }
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            return;
        }
        if (!clicked.equals(this.inventory)) {
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        if (!this.editable) {
            event.setCancelled(true);
        }
        if (!this.map.containsKey(event.getSlot())) {
            return;
        }
        this.map.get(event.getSlot()).accept(player, event);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (this.players.isEmpty()) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (event.getInventory() != this.inventory) {
            return;
        }
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        this.remove();
    }

    protected void remove() {
        new BukkitRunnable(){

            public void run() {
                if (VisualGUI.this.players.isEmpty() && VisualGUI.this.hasListener()) {
                    VisualGUI.this.unregister();
                }
            }
        }.runTaskLater(this.plugin, 80L);
    }

    protected boolean hasListener() {
        for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)this.plugin)) {
            if (listener.getListener() != this) continue;
            return true;
        }
        return false;
    }
}

