/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.gui;

import com.moderocky.guardian.mask.gui.TextGUI;
import com.moderocky.guardian.mask.template.CompleteListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class BookGUI
implements TextGUI,
CompleteListener {
    private final BookMeta meta;
    private final String bookCode = UUID.randomUUID().getMostSignificantBits() + "";
    private final List<Player> players = new ArrayList<Player>();
    private final TreeMap<String, Consumer<Player>> map = new TreeMap();
    private final TreeMap<String, Boolean> reopenMap = new TreeMap();
    private final Plugin plugin;

    public BookGUI(Plugin plugin, String title) {
        this.plugin = plugin;
        this.meta = (BookMeta)new ItemStack(Material.WRITTEN_BOOK).getItemMeta();
    }

    private void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public CompleteListener getListener() {
        return this;
    }

    @Override
    public void open(Player player) {
        ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK);
        itemStack.setItemMeta((ItemMeta)this.meta);
        player.openBook(itemStack);
    }

    @Override
    public boolean isOpen(Player player) {
        return false;
    }

    public void reset() {
        this.meta.setPages(new ArrayList());
    }

    public void addPage(@NotNull BaseComponent[] page) {
        this.meta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{page});
    }

    public void addPages(BaseComponent[] ... pages) {
        this.meta.spigot().addPage(pages);
    }

    public void addPages(@NotNull List<BaseComponent[]> pages) {
        this.meta.spigot().addPage((BaseComponent[][])pages.toArray((T[])new BaseComponent[0][]));
    }

    public ClickEvent createButton(@NotNull Consumer<Player> consumer) {
        return this.createButton(consumer, true);
    }

    public BaseComponent[] page(BaseComponent[] ... lines) {
        ComponentBuilder builder = new ComponentBuilder("");
        boolean first = true;
        for (BaseComponent[] line : lines) {
            builder.append(line);
            if (!first) {
                builder.append(System.lineSeparator());
            }
            if (!first) continue;
            first = false;
        }
        return builder.create();
    }

    public void setPages(BaseComponent[] ... pages) {
        this.meta.spigot().setPages(pages);
    }

    public void setPages(@NotNull List<BaseComponent[]> pages) {
        this.meta.spigot().setPages(pages);
    }

    public ClickEvent createButton(@NotNull Consumer<Player> consumer, boolean reopen) {
        String key = UUID.randomUUID().toString();
        this.map.put(key, consumer);
        this.reopenMap.put(key, reopen);
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/!bk " + this.bookCode + " " + key);
    }

    public ClickEvent createButton(int page) {
        return new ClickEvent(ClickEvent.Action.CHANGE_PAGE, page + "");
    }

    @EventHandler
    public void onClick(PlayerCommandPreprocessEvent event) {
        String string = event.getMessage();
        if (!string.contains("!bk") || string.split(" ").length < 3) {
            return;
        }
        if (!string.split(" ")[1].equalsIgnoreCase(this.bookCode)) {
            return;
        }
        if (!this.map.containsKey(string.split(" ")[2])) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        String key = string.split(" ")[2];
        boolean boo = this.reopenMap.getOrDefault(key, false);
        Consumer<Player> consumer = this.map.get(key);
        consumer.accept(player);
        if (boo) {
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.open(player), 0L);
        }
    }

    private void remove() {
        new BukkitRunnable(){

            public void run() {
                if (BookGUI.this.players.isEmpty() && BookGUI.this.hasListener()) {
                    BookGUI.this.unregister();
                }
            }
        }.runTaskLater(this.plugin, 80L);
    }

    private boolean hasListener() {
        for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)this.plugin)) {
            if (listener.getListener() != this) continue;
            return true;
        }
        return false;
    }
}

