/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.moderocky.guardian.mask.api.MagicNumberList;
import com.moderocky.guardian.mask.mirror.logic.ReflectiveBiOperation;
import com.moderocky.guardian.mask.mirror.logic.ReflectiveOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class MagicList<T>
extends ArrayList<T> {
    public MagicList() {
    }

    public MagicList(Collection<T> collection) {
        super(collection);
    }

    @SafeVarargs
    public MagicList(T ... ts) {
        super(Arrays.asList(ts));
    }

    public static MagicList<String> ofWords(String string) {
        return new MagicList<String>(string.split("\\s+"));
    }

    public static MagicList<String> from(JsonArray array) {
        MagicList<String> list = new MagicList<String>();
        for (JsonElement element : array) {
            list.add(element.getAsString());
        }
        return list;
    }

    public static <T> MagicList<T> from(JsonArray array, Function<JsonElement, T> converter) {
        MagicList<T> list = new MagicList<T>();
        for (JsonElement element : array) {
            list.add(converter.apply(element));
        }
        return list;
    }

    @SafeVarargs
    public static <T> MagicList<T> from(Collection<T> ... collections) {
        MagicList<T> list = new MagicList<T>();
        for (Collection<T> collection : collections) {
            list.addAll(collection);
        }
        return list;
    }

    public MagicList<T> from(int start) {
        return this.from(start, this.size());
    }

    public MagicList<T> from(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Start index must be positive!");
        }
        if (end > this.size()) {
            throw new IllegalArgumentException("End index must not be greater than the list's size!");
        }
        MagicList<T> list = new MagicList<T>();
        for (int i = start; i < end; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public <R> MagicList<R> collectIgnoreNull(Function<T, R> function) {
        MagicList<T> list = new MagicList<T>();
        for (Object thing : this) {
            R blob = function.apply(thing);
            if (blob == null) continue;
            list.add(blob);
        }
        return list;
    }

    @Override
    public void forEach(ReflectiveOperation<T> function) {
        this.forEach(function, null);
    }

    public void forEach(ReflectiveOperation<T> function, @Nullable Consumer<Throwable> failure) {
        for (Object thing : this) {
            try {
                function.attempt(thing);
            }
            catch (Throwable throwable) {
                if (failure == null) continue;
                failure.accept(throwable);
            }
        }
    }

    public <R> MagicList<R> collect(ReflectiveBiOperation<T, R> function) {
        return this.collect(function, true);
    }

    public <R> MagicList<R> collect(ReflectiveBiOperation<T, R> function, boolean ignoreFailures) {
        MagicList<T> list = new MagicList<T>();
        for (Object thing : this) {
            try {
                list.add(function.attempt(thing));
            }
            catch (Throwable throwable) {
                if (ignoreFailures) continue;
                list.add(function.otherwise(thing, throwable));
            }
        }
        return list;
    }

    public <R> MagicList<R> collect(Function<T, R> function) {
        MagicList<T> list = new MagicList<T>();
        for (Object thing : this) {
            list.add(function.apply(thing));
        }
        return list;
    }

    public <U, R> MagicList<R> collect(BiFunction<T, U, R> function, U argument) {
        MagicList<T> list = new MagicList<T>();
        for (Object thing : this) {
            list.add(function.apply(thing, argument));
        }
        return list;
    }

    public <Q> MagicList<Q> castConvert(Class<Q> cls) {
        return this.castConvert();
    }

    public <Q> MagicList<Q> castConvert() {
        MagicList<T> list = new MagicList<T>();
        for (Object thing : this) {
            list.add(thing);
        }
        return list;
    }

    public T getRandom() {
        return (T)this.get(ThreadLocalRandom.current().nextInt(this.size()));
    }

    public <Q extends Number> MagicNumberList<Q> asMagicNumbers() {
        return new MagicNumberList(this);
    }

    @Override
    public T[] toArray() {
        return super.toArray();
    }

    @SafeVarargs
    public final void addAll(T ... ts) {
        this.addAll(Arrays.asList(ts));
    }

    @SafeVarargs
    public final void addAll(int i, T ... ts) {
        this.addAll(i, Arrays.asList(ts));
    }

    public JsonArray toJsonStringArray() {
        JsonArray array = new JsonArray();
        for (Object thing : this) {
            array.add(thing.toString());
        }
        return array;
    }

    public JsonArray toJsonArray(Function<T, JsonElement> converter) {
        JsonArray array = new JsonArray();
        for (Object thing : this) {
            array.add(converter.apply(thing));
        }
        return array;
    }

    @Override
    public T getFirst() {
        return (T)this.get(0);
    }

    @Override
    public T getLast() {
        return (T)this.get(this.size() - 1);
    }

    public ArrayList<T> toArrayList() {
        return new ArrayList(this);
    }

    public Set<T> toSet() {
        return new HashSet(this);
    }
}

