/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.shape;

import com.moderocky.guardian.logic.ascendancy.IOrder4;
import com.moderocky.guardian.logic.ascendancy.Polytope;
import com.moderocky.guardian.logic.handler.LogicUtils;
import com.moderocky.guardian.logic.shape.Dion;
import com.moderocky.guardian.logic.shape.Polygon;
import com.moderocky.guardian.logic.shape.Polyhedron;
import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Polychoron
implements Polytope,
IOrder4 {
    private final List<Vertex> vertices = new ArrayList<Vertex>();
    private final List<Integer> indices = new ArrayList<Integer>();
    private final int vertexCount;

    public Polychoron(List<Vertex> vertices) {
        this.vertexCount = vertices.size();
        for (int i = 0; i < this.vertexCount; ++i) {
            this.vertices.add(vertices.get(i));
            this.indices.add(i);
        }
    }

    @Override
    public int getOrder() {
        return 4;
    }

    @Override
    public Vertex[] vertices() {
        return new Vertex[0];
    }

    @Override
    public boolean contains(Polytope polytope) {
        return false;
    }

    @Override
    public Polychoron[] polychorons() {
        return new Polychoron[]{this};
    }

    @Override
    public boolean contains(@NotNull Polygon polygon) {
        return false;
    }

    @Override
    public Polyhedron[] polyhedrons() {
        ArrayList<Polyhedron> polyhedra = new ArrayList<Polyhedron>();
        for (Vertex[] quads : LogicUtils.getQuads(this.vertices)) {
            polyhedra.add(new Polyhedron(Arrays.asList(quads)));
        }
        return polyhedra.toArray(new Polyhedron[0]);
    }

    @Override
    public boolean contains(@NotNull Dion dion) {
        return false;
    }

    @Override
    public Polygon[] polygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Vertex[] trio : LogicUtils.getTrios(this.vertices)) {
            polygons.add(new Polygon(Arrays.asList(trio), Arrays.asList(0, 1, 2)));
        }
        return polygons.toArray(new Polygon[0]);
    }

    @Override
    public boolean contains(@NotNull Vertex vertex) {
        return false;
    }

    @Override
    public Dion[] dions() {
        ArrayList<Dion> dions = new ArrayList<Dion>();
        for (Vertex[] pair : LogicUtils.getPairs(this.vertices)) {
            dions.add(new Dion(pair[0], pair[1]));
        }
        return dions.toArray(new Dion[0]);
    }
}

