/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.handler;

import com.moderocky.guardian.logic.ascendancy.Polytope;
import com.moderocky.guardian.logic.handler.TransType;
import com.moderocky.guardian.logic.shape.Dion;
import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Manifold {
    @NotNull
    private final Set<Polytope> polytopes = new HashSet<Polytope>();
    private final double[] origin = new double[3];

    public void plot(@NotNull Polytope polytope) {
        if (this.polytopes.contains(polytope)) {
            return;
        }
        this.polytopes.add(polytope);
    }

    public void remove(@NotNull Polytope polytope) {
        this.polytopes.remove(polytope);
    }

    public boolean contains(@NotNull Polytope polytope) {
        return this.polytopes.contains(polytope);
    }

    public void clear() {
        this.polytopes.clear();
    }

    @NotNull
    public Set<Polytope> getPolytopes() {
        return this.polytopes;
    }

    public void setOrigin(double x, double y, double z) {
        this.origin[0] = x;
        this.origin[0] = y;
        this.origin[0] = z;
    }

    public List<Polytope> getEncompassing(Polytope polytope) {
        ArrayList<Polytope> polytopes = new ArrayList<Polytope>();
        for (Polytope poly : this.getPolytopes()) {
            if (!poly.contains(polytope)) continue;
            polytopes.add(poly);
        }
        return polytopes;
    }

    public double[] getOrigin() {
        return this.origin;
    }

    public Dion getLine(Vertex start, Vertex end) {
        return new Dion(start, end);
    }

    public Vector getVector(Vertex start, Vertex end) {
        return this.getLine(start, end).toVector();
    }

    public void transform(@NotNull Polytope polytope, double[] origin, @NotNull TransType trans, Number value) {
        trans.accept(polytope, origin, value);
    }
}

