/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.handler;

import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class LogicUtils {
    public static List<Block> getBlocks(BoundingBox boundingBox, World world) {
        Location[] bounds = new Location[]{boundingBox.getMin().toLocation(world), boundingBox.getMax().toLocation(world)};
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double y = bounds[0].getY(); y <= bounds[1].getY(); y += 1.0) {
            for (double x = bounds[0].getX(); x <= bounds[1].getX(); x += 1.0) {
                for (double z = bounds[0].getZ(); z <= bounds[1].getZ(); z += 1.0) {
                    blocks.add(new Location(bounds[0].getWorld(), (double)((int)x), (double)((int)y), (double)((int)z)).getBlock());
                }
            }
        }
        return blocks;
    }

    public static boolean containsList(List<List<Integer>> list, List<Integer> listItem) {
        Collections.sort(listItem);
        for (List<Integer> temp : list) {
            if (temp.size() != listItem.size()) continue;
            Collections.sort(temp);
            if (!temp.equals(listItem)) continue;
            return true;
        }
        return false;
    }

    public static Vertex getMidpoint(Vertex start, Vertex end) {
        return new Vertex((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0, (start.getZ() + end.getZ()) / 2.0);
    }

    public static List<Vertex> toVertices(List<Location> locations) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        locations.forEach(location -> vertices.add(Vertex.from(location)));
        return vertices;
    }

    public static List<Location> toLocations(List<Vertex> vertices, World world) {
        ArrayList<Location> locations = new ArrayList<Location>();
        vertices.forEach(vertex -> locations.add(vertex.toLocation(world)));
        return locations;
    }

    public static List<Vertex> getVertices(BoundingBox box) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(new Vertex(box.getMinX(), box.getMinY(), box.getMinZ()));
        vertices.add(new Vertex(box.getMinX(), box.getMinY(), box.getMaxZ()));
        vertices.add(new Vertex(box.getMinX(), box.getMaxY(), box.getMinZ()));
        vertices.add(new Vertex(box.getMinX(), box.getMaxY(), box.getMaxZ()));
        vertices.add(new Vertex(box.getMaxX(), box.getMinY(), box.getMinZ()));
        vertices.add(new Vertex(box.getMaxX(), box.getMinY(), box.getMaxZ()));
        vertices.add(new Vertex(box.getMaxX(), box.getMaxY(), box.getMinZ()));
        vertices.add(new Vertex(box.getMaxX(), box.getMaxY(), box.getMaxZ()));
        return vertices;
    }

    public static BoundingBox getBoundingBox(List<Vertex> vertices) {
        if (vertices.size() == 8) {
            return BoundingBox.of((Vector)vertices.get(0).toVector(), (Vector)vertices.get(7).toVector());
        }
        if (vertices.size() > 1) {
            return BoundingBox.of((Vector)vertices.get(0).toVector(), (Vector)vertices.get(1).toVector());
        }
        throw new IllegalArgumentException();
    }

    public static BoundingBox getBoundingBox(Vertex ... vertices) {
        if (vertices.length == 8) {
            return BoundingBox.of((Vector)vertices[0].toVector(), (Vector)vertices[7].toVector());
        }
        if (vertices.length > 1) {
            return BoundingBox.of((Vector)vertices[0].toVector(), (Vector)vertices[1].toVector());
        }
        throw new IllegalArgumentException();
    }

    public static <X> List<X[]> getPairs(Collection<X> collection) {
        ArrayList<X> list = new ArrayList<X>(collection);
        ArrayList<X[]> xes = new ArrayList<X[]>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                xes.add(new Object[]{list.get(i), list.get(j)});
            }
        }
        return xes;
    }

    public static <X> List<X[]> getTrios(Collection<X> collection) {
        ArrayList<X> list = new ArrayList<X>(collection);
        ArrayList<X[]> xes = new ArrayList<X[]>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                for (int k = i + 1; k < list.size(); ++k) {
                    xes.add(new Object[]{list.get(i), list.get(j), list.get(k)});
                }
            }
        }
        return xes;
    }

    public static <X> List<X[]> getQuads(Collection<X> collection) {
        ArrayList<X> list = new ArrayList<X>(collection);
        ArrayList<X[]> xes = new ArrayList<X[]>();
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                for (int k = i + 1; k < list.size(); ++k) {
                    for (int l = i + 1; l < list.size(); ++l) {
                        xes.add(new Object[]{list.get(i), list.get(j), list.get(k), list.get(l)});
                    }
                }
            }
        }
        return xes;
    }
}

