/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.mask.template.CompleteListener;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerAttemptPickupItemListener
implements CompleteListener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(PlayerAttemptPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Location location = event.getItem().getLocation();
        String hache = player.hashCode() + "0x13" + location.getBlockX() + "0" + location.getBlockY() + "0" + location.getBlockZ();
        Boolean boo = this.api.getCachedResult(hache);
        if (boo != null) {
            event.setCancelled(boo.booleanValue());
        } else {
            for (Zone zone : this.api.getZones(location)) {
                if (zone.canInteract(location, "pick_up_items", player)) continue;
                event.setCancelled(true);
                this.api.addCachedResult(hache, true);
                this.api.denyEvent(player);
                return;
            }
            this.api.addCachedResult(hache, false);
        }
    }
}

