/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.mask.template.CompleteListener;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.jetbrains.annotations.NotNull;

public class EntityExplodeListener
implements CompleteListener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType() == EntityType.PLAYER) {
            return;
        }
        new ArrayList<Block>(event.blockList()).forEach(block -> {
            Location location = block.getLocation();
            for (Zone zone : this.api.getZones(location)) {
                if (zone.canInteract(location, "mob_griefing")) continue;
                event.blockList().remove(block);
                break;
            }
        });
    }
}

