/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.mask.template.CompleteListener;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jetbrains.annotations.NotNull;

public class BlockPlaceListener
implements CompleteListener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Location location = block.getLocation();
        Player player = event.getPlayer();
        String hache = player.hashCode() + "0x12" + block.hashCode();
        Boolean boo = this.api.getCachedResult(hache);
        if (boo != null) {
            event.setCancelled(boo.booleanValue());
        } else {
            for (Zone zone : this.api.getZones(location)) {
                if (zone.canInteract(location, "place_blocks", player)) continue;
                event.setCancelled(true);
                this.api.addCachedResult(hache, true);
                this.api.denyEvent(player);
                return;
            }
            this.api.addCachedResult(hache, false);
        }
    }
}

