/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.EventMethRef;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class BlanketUncaughtListener
implements Listener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler
    public <Z extends Event> void onEvent(Z event) {
        if (!(event instanceof Cancellable)) {
            return;
        }
        Cancellable cancellable = (Cancellable)event;
        if (cancellable.isCancelled()) {
            return;
        }
        EventMethRef ref = this.api.getMethRef(event.getClass());
        if (ref == null) {
            return;
        }
        String flag = ref.getFlag();
        boolean cache = ref.hashCache();
        try {
            Method method = event.getClass().getMethod("getLocation", new Class[0]);
            Location location = (Location)method.invoke(event, new Object[0]);
            if (event instanceof PlayerEvent) {
                Player player = ((PlayerEvent)event).getPlayer();
                String hache = player.hashCode() + ref.hashKey() + location.getBlockX() + "0" + location.getBlockY() + "0" + location.getBlockZ();
                Boolean boo = this.api.getCachedResult(hache);
                if (boo != null && cache) {
                    cancellable.setCancelled(boo.booleanValue());
                } else {
                    for (Zone zone : this.api.getZones(location)) {
                        if (zone.canInteract(location, flag, player)) continue;
                        cancellable.setCancelled(true);
                        if (cache) {
                            this.api.addCachedResult(hache, true);
                        }
                        this.api.denyEvent(player);
                        return;
                    }
                    if (cache) {
                        this.api.addCachedResult(hache, false);
                    }
                }
            } else {
                String hache = ref.hashKey() + location.getBlockX() + "0" + location.getBlockY() + "0" + location.getBlockZ();
                Boolean boo = this.api.getCachedResult(hache);
                if (boo != null && cache) {
                    cancellable.setCancelled(boo.booleanValue());
                } else {
                    for (Zone zone : this.api.getZones(location)) {
                        if (zone.canInteract(location, flag)) continue;
                        cancellable.setCancelled(true);
                        if (cache) {
                            this.api.addCachedResult(hache, true);
                        }
                        return;
                    }
                    if (cache) {
                        this.api.addCachedResult(hache, false);
                    }
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return;
        }
    }
}

