/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.Child;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import dev.moderocky.mirror.Mirror;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public interface Parent<Z extends Zone> {
    @NotNull
    public List<Z> getChildren();

    public boolean hasChildren();

    public void addChild(@NotNull Z var1);

    public void removeChild(@NotNull Z var1);

    public void clearChildren();

    default public void saveChildren(JsonObject section) {
        JsonArray array = new JsonArray();
        for (Zone child : this.getChildren()) {
            JsonObject object = new JsonObject();
            String id = child.getKey().getKey();
            child.save(object);
            object.addProperty("namespace", child.getKey().getNamespace());
            object.addProperty("key", child.getKey().getKey());
            object.addProperty("class_loader", child.getClass().getName());
            array.add((JsonElement)object);
        }
        section.add("children", (JsonElement)array);
    }

    default public void loadChildren(JsonObject section) {
        GuardianAPI api = Guardian.getApi();
        if (section.has("children")) {
            return;
        }
        JsonArray array = section.getAsJsonArray("children");
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            if (!object.has("class_loader")) continue;
            String namespace = object.get("namespace").getAsString();
            String key = object.get("key").getAsString();
            try {
                NamespacedKey namespacedKey = new NamespacedKey(namespace, key);
                Mirror mirror = Mirror.mirror(object.get("class_loader").getAsString());
                Zone zone = (Zone)mirror.instantiate(namespacedKey, object);
                if (zone instanceof Child) {
                    ((Child)((Object)zone)).setParent((Zone)((Object)this));
                }
                this.addChild(zone);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

