/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalChild;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Parent;
import com.moderocky.guardian.api.PolyhedralZone;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.logic.handler.LogicUtils;
import com.moderocky.guardian.logic.shape.Vertex;
import com.moderocky.guardian.mask.api.MagicList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CuboidalZone
extends Zone
implements Parent<CuboidalChild> {
    @NotNull
    private final List<CuboidalChild> children = new ArrayList<CuboidalChild>();
    private GuardianAPI api;
    private BoundingBox boundingBox;
    private Location location;
    private UUID owner;
    private String name = null;
    private String description = null;

    public CuboidalZone(@NotNull NamespacedKey id) {
        super(id);
        throw new IllegalArgumentException("This constructor may not be used!");
    }

    public CuboidalZone(@NotNull String id, @NotNull BoundingBox boundingBox, @NotNull World world) {
        super(Guardian.getNamespacedKey(id));
        this.boundingBox = boundingBox;
        this.location = boundingBox.getCenter().toLocation(world);
        this.api = Guardian.getApi();
    }

    public CuboidalZone(@NotNull NamespacedKey id, @NotNull JsonObject object) {
        super(id, object);
    }

    public static CuboidalZone createZone(Player player, String id, Location l1, Location l2) {
        BoundingBox boundingBox = BoundingBox.of((Location)l1, (Location)l2);
        CuboidalZone zone = new CuboidalZone(id, boundingBox, l1.getWorld());
        zone.setOwner(player.getUniqueId());
        return zone;
    }

    public static CuboidalZone createZone(String id, Location l1, Location l2) {
        BoundingBox boundingBox = BoundingBox.of((Location)l1, (Location)l2);
        CuboidalZone zone = new CuboidalZone(id, boundingBox, l1.getWorld());
        zone.setOwner(null);
        return zone;
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return BoundingBox.of((Vector)this.boundingBox.getMin(), (Vector)this.boundingBox.getMax().add(new Vector(1, 1, 1)));
    }

    @Override
    public <Z extends Zone> boolean overlaps(Z zone) {
        if (zone instanceof CuboidalZone) {
            return this.overlaps((CuboidalZone)zone);
        }
        if (zone instanceof PolyhedralZone) {
            return this.overlaps((PolyhedralZone)zone);
        }
        return super.overlaps(zone);
    }

    public boolean overlaps(PolyhedralZone zone) {
        for (Vertex vertex : zone.getPolyhedron().getVertices()) {
            if (!this.getBoundingBox().contains(vertex.toVector())) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(CuboidalZone zone) {
        return zone.getBoundingBox().overlaps(this.boundingBox);
    }

    public boolean eclipses(CuboidalZone zone) {
        return this.overlaps(zone) && this.boundingBox.contains(zone.getBoundingBox());
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        if (owner != null && !this.isAllowed(owner)) {
            this.addPlayer(owner);
        }
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public double getRadius() {
        return this.boundingBox.getMax().distance(this.boundingBox.getMin()) / 2.0 + 2.0;
    }

    @Override
    public boolean isInside(@NotNull Location location) {
        BoundingBox box = BoundingBox.of((Vector)this.boundingBox.getMin(), (Vector)this.boundingBox.getMax().add(new Vector(1, 1, 1)));
        return location.getWorld() == this.getWorld() && box.expand(0.1, 0.1, 0.1).contains(location.toVector());
    }

    @Override
    public boolean canEdit(@NotNull UUID player) {
        return player.equals(this.getOwner()) || Bukkit.getOfflinePlayer((UUID)player).isOp();
    }

    @Override
    @NotNull
    public List<Block> getBlocks() {
        return LogicUtils.getBlocks(this.getBoundingBox(), this.getWorld());
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void showBounds() {
        this.api.displayBox(this.getBoundingBox().clone().expand(0.05, 0.05, 0.05), this.getWorld(), null);
        if (this.hasChildren()) {
            for (CuboidalChild child : this.getChildren()) {
                this.api.displayBox(child.getBoundingBox().clone().expand(0.05, 0.05, 0.05), this.getWorld(), Particle.VILLAGER_HAPPY, null);
            }
        }
    }

    @Override
    public void save(@NotNull JsonObject object) {
        this.api = Guardian.getApi();
        World world = this.getWorld();
        Location l1 = this.boundingBox.getMin().toLocation(world);
        Location l2 = this.boundingBox.getMax().toLocation(world);
        object.addProperty("location", this.api.serialisePosition(this.getLocation()));
        object.addProperty("min", this.api.serialisePosition(l1));
        object.addProperty("max", this.api.serialisePosition(l2));
        JsonArray flags = new JsonArray();
        for (String flag : this.getFlags()) {
            flags.add(flag);
        }
        object.add("flags", (JsonElement)flags);
        JsonArray players = new JsonArray();
        this.getAllowedPlayers().forEach(uuid -> players.add(uuid.toString()));
        object.add("players", (JsonElement)players);
        object.addProperty("owner", this.getOwner() != null ? this.getOwner().toString() : null);
        object.addProperty("name", this.name);
        JsonArray desc = new JsonArray();
        if (this.description != null) {
            for (String s : this.description.split("\n")) {
                desc.add(s);
            }
        }
        object.add("description", (JsonElement)(this.description == null ? null : desc));
        this.saveChildren(object);
    }

    @Override
    public void load(@NotNull JsonObject object) {
        this.api = Guardian.getApi();
        this.location = this.api.deserialisePosition(object.get("location").getAsString());
        Location l1 = this.api.deserialisePosition(object.get("min").getAsString());
        Location l2 = this.api.deserialisePosition(object.get("max").getAsString());
        this.boundingBox = BoundingBox.of((Location)l1, (Location)l2);
        MagicList list = new MagicList();
        for (JsonElement element : object.getAsJsonArray("flags")) {
            this.addFlag(element.getAsString());
        }
        for (JsonElement element : object.getAsJsonArray("players")) {
            this.addPlayer(UUID.fromString(element.getAsString()));
        }
        if (object.has("owner") && object.get("owner").isJsonPrimitive()) {
            String string = object.get("owner").getAsString();
            this.setOwner(UUID.fromString(string));
        } else {
            this.setOwner(null);
        }
        String string = this.name = object.get("name") != null && !object.get("name").isJsonNull() ? object.get("name").getAsString() : null;
        if (!object.has("description") || object.get("description").isJsonNull()) {
            this.description = null;
        } else {
            MagicList<String> desc = MagicList.from(object.getAsJsonArray("description"), JsonElement::getAsString);
            this.description = String.join((CharSequence)System.lineSeparator(), desc);
        }
        this.loadChildren(object);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String s) {
        this.description = s;
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    @NotNull
    public List<CuboidalChild> getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public void addChild(@NotNull CuboidalChild child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    @Override
    public void removeChild(@NotNull CuboidalChild child) {
        this.children.remove(child);
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }
}

