/*
 * Decompiled with CFR 0.152.
 */
package dev.moderocky.mirror;

import dev.moderocky.mirror.IMirror;
import dev.moderocky.mirror.Mirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldMirror<T>
implements IMirror<T> {
    private final transient Field field;
    @NotNull
    private final transient IMirror<?> parent;
    private final transient Object target;

    public FieldMirror(@NotNull Field field, @NotNull IMirror<?> parent, @NotNull Object target) {
        this.field = field;
        this.parent = parent;
        this.target = target;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    @Override
    public <Q extends Annotation> boolean hasAnnotation(Class<Q> annotation) {
        return this.field.getDeclaredAnnotation(annotation) != null;
    }

    @Override
    public <Q extends Annotation> Q getAnnotation(Class<Q> annotation) {
        return this.field.getDeclaredAnnotation(annotation);
    }

    public T get() {
        try {
            return (T)this.field.get(this.target);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void get(Consumer<T> success, @Nullable Consumer<Throwable> failure) {
        block3: {
            try {
                if (success != null) {
                    success.accept(this.get());
                }
            }
            catch (Throwable throwable) {
                if (failure == null) break block3;
                failure.accept(throwable);
            }
        }
    }

    public void get(Consumer<T> success) {
        this.get(success, null);
    }

    public void set(T obj) {
        try {
            this.deconst().set(this.target, obj);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public T get(Object target) {
        try {
            return (T)this.field.get(target);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void get(Consumer<T> success, @Nullable Consumer<Throwable> failure, Object target) {
        block3: {
            try {
                if (success != null) {
                    success.accept(this.get(target));
                }
            }
            catch (Throwable throwable) {
                if (failure == null) break block3;
                failure.accept(throwable);
            }
        }
    }

    public void get(Consumer<T> success, Object target) {
        this.get(success, null, target);
    }

    public void set(Object target, T obj) {
        try {
            this.deconst().set(target, obj);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean isAnonymous() {
        return this.field.getType().isAnonymousClass();
    }

    public boolean isAnnotation() {
        return this.field.getType().isAnnotation();
    }

    public boolean isPrimitive() {
        return this.field.getType().isPrimitive();
    }

    public boolean isMap() {
        return this.field.getType() == Map.class || Map.class.isAssignableFrom(this.field.getType()) || this.field.getType().isInstance(Map.class);
    }

    public boolean isPlural() {
        return this.isArray() || this.isCollection();
    }

    public boolean isCollection() {
        return this.field.getType() == Collection.class || Collection.class.isAssignableFrom(this.field.getType()) || this.field.getType().isInstance(Collection.class);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public boolean isArray() {
        return this.field.getType().isArray();
    }

    public boolean isEnum() {
        return this.field.getType().isEnum();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.field.getModifiers());
    }

    public boolean isConstant() {
        return this.isStatic() && this.isFinal() && this.isPublic();
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    public Class<T> getType() {
        return this.field.getType();
    }

    public Class<?> getDeclarator() {
        return this.field.getDeclaringClass();
    }

    @Override
    public <Q> IMirror<Q> getParent() {
        return this.parent;
    }

    @Override
    public <Q> Q getTarget() {
        return (Q)this.target;
    }

    private Field deconst() {
        try {
            if (!this.isConstant()) {
                return this.field;
            }
            new Mirror<Field>(this.field).field("modifiers").set(this.field.getModifiers() & 0xFFFFFFEF);
            return this.field;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean matches(FieldMirror<?> mirror) {
        if (!mirror.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        if (mirror.isStatic() ^ this.isStatic()) {
            return false;
        }
        if (mirror.isEnum() ^ this.isEnum()) {
            return false;
        }
        return mirror.getType().isAssignableFrom(this.getType()) || this.getType().isAssignableFrom(mirror.getType()) || mirror.getType().isInstance(this.getType()) || this.getType().isInstance(mirror.getType());
    }

    public FieldMirror<T> getMatching(Mirror<?> mirror) {
        for (FieldMirror fieldMirror : mirror.getFieldMirrors()) {
            if (!this.matches(fieldMirror)) continue;
            return fieldMirror;
        }
        return null;
    }

    public boolean hasMatching(Mirror<?> mirror) {
        for (FieldMirror fieldMirror : mirror.getFieldMirrors()) {
            if (!this.matches(fieldMirror)) continue;
            return true;
        }
        return false;
    }

    public void ifHasMatching(Mirror<?> mirror, Consumer<FieldMirror<T>> consumer) {
        this.tryCatch(() -> {
            FieldMirror<T> field = this.getMatching(mirror);
            if (field != null && consumer != null) {
                consumer.accept(field);
            }
        }, null);
    }

    @Override
    public Field getLiteral() {
        return this.field;
    }
}

