/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Flags of Zone")
@Description(value={"Accesses the flags of a Guardian zone. ", "Flags used by Guardian are togglable protections for the zone. "})
@Examples(value={"add \"prevent_teleport\" to the flags of zone \"my_zone\"", "add \"break_blocks\" and \"place_blocks\" to the flags of zone \"my_zone\"", "add {list_of_flags::*} to guardian zone \"my_zone\"'s flags", "reset zone \"my_zone\"'s flags", "set guardian zone \"my_zone\"'s flags to {list_of_flags::*}"})
@Since(value="1.0.4")
public class ZoneFlagsExpr
extends SimpleExpression<String> {
    private Expression<String> stringExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected String[] get(@NotNull Event event) {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return new String[0];
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return new String[0];
        }
        Zone zone = api.getZone(id);
        return zone.getFlags().toArray(new String[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
    }

    public void change(@NotNull Event event, @Nullable Object[] objects, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) throws UnsupportedOperationException {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return;
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return;
        }
        Zone zone = api.getZone(id);
        String[] strings = objects == null ? null : (String[])Arrays.copyOf(objects, objects.length, String[].class);
        switch (mode) {
            case SET: {
                if (strings == null) break;
                zone.getFlags().forEach(zone::removeFlag);
                for (String line : strings) {
                    if (!api.isProtectionFlag(line)) continue;
                    zone.addFlag(line);
                }
                break;
            }
            case ADD: {
                if (strings == null) break;
                for (String line : strings) {
                    if (!api.isProtectionFlag(line)) continue;
                    zone.addFlag(line);
                }
                break;
            }
            case DELETE: {
                zone.clearFlags();
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                if (strings == null) break;
                for (String string : strings) {
                    zone.removeFlag(string);
                }
                break;
            }
            case RESET: {
                zone.clearFlags();
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "flags of zone " + string;
    }

    static {
        Skript.registerExpression(ZoneFlagsExpr.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] flags of [guardian] zone %string%", "[guardian] zone %string%'s flags"});
    }
}

