/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.mirror;

import com.moderocky.guardian.mask.mirror.logic.ReflectiveBiOperation;
import com.moderocky.guardian.mask.mirror.logic.ReflectiveOperation;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface Reflective {
    default public boolean tryCatch(Runnable action) {
        return this.tryCatch(action, null);
    }

    default public boolean tryCatch(Runnable action, @Nullable Consumer<Throwable> failure) {
        try {
            if (action != null) {
                action.run();
            }
            return true;
        }
        catch (Throwable throwable) {
            if (failure != null) {
                failure.accept(throwable);
            }
            return false;
        }
    }

    default public boolean tryCatch(Consumer<Reflective> action, @Nullable Consumer<Throwable> failure) {
        try {
            if (action != null) {
                action.accept(this);
            }
            return true;
        }
        catch (Throwable throwable) {
            if (failure != null) {
                failure.accept(throwable);
            }
            return false;
        }
    }

    default public <R> R tryCatchFunc(Function<Reflective, R> action, @Nullable Consumer<Throwable> failure) {
        try {
            return action.apply(this);
        }
        catch (Throwable throwable) {
            if (failure != null) {
                failure.accept(throwable);
            }
            return null;
        }
    }

    default public <R> R tryFunc(Function<Reflective, R> action, R def) {
        try {
            return action.apply(this);
        }
        catch (Throwable throwable) {
            return def;
        }
    }

    default public <Q> boolean attempt(ReflectiveOperation<Q> operation, Q obj) {
        try {
            operation.attempt(obj);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    default public <Q, R> R attempt(ReflectiveBiOperation<Q, R> operation, Q obj) {
        try {
            return operation.attempt(obj);
        }
        catch (Throwable throwable) {
            return operation.otherwise(obj, throwable);
        }
    }
}

