/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.internal.utility;

import com.google.common.base.Charsets;
import com.moderocky.guardian.mask.Mask;
import com.moderocky.guardian.mask.annotation.Internal;
import com.moderocky.guardian.mask.api.Compressive;
import com.moderocky.guardian.mask.template.BukkitPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@Internal
public class FileManager
implements Compressive {
    public static final FileManager MANAGER = new FileManager();

    public static FileConfiguration getFile(@NotNull String folder, @NotNull String name) {
        File path = new File(folder, name);
        return YamlConfiguration.loadConfiguration((File)path);
    }

    public static void putIfAbsent(@NotNull File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void save(final @NotNull FileConfiguration file, final @NotNull File path) {
        block2: {
            try {
                FileManager.putIfAbsent(path);
                file.save(path);
            }
            catch (IOException e) {
                if (!Mask.getPlugin().isBukkit() || !(Mask.getPlugin() instanceof BukkitPlugin)) break block2;
                new BukkitRunnable(){

                    public void run() {
                        FileManager.save(file, path);
                    }
                }.runTaskLater((Plugin)((BukkitPlugin)Mask.getPlugin()), 30L);
            }
        }
    }

    public static void clear(@NotNull File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.print("");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStreamReader getReader(@NotNull File file) {
        try {
            return new InputStreamReader(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException();
        }
    }

    public static void writeCompressed(File file, String content) {
        FileManager.writeBytes(file, MANAGER.zip(content));
    }

    public static void writeBytes(File file, byte[] content) {
        FileManager.write(file, Base64.getEncoder().encodeToString(content));
    }

    public static void write(File file, String content) {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.print(content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String readCompressed(File file) {
        return MANAGER.unzip(FileManager.readBytes(file));
    }

    public static byte[] readBytes(File file) {
        return Base64.getDecoder().decode(FileManager.read(file).getBytes(StandardCharsets.UTF_8));
    }

    public static String read(File file) {
        StringBuilder builder = new StringBuilder();
        try {
            FileReader reader = new FileReader(file);
            while (reader.ready()) {
                char c = (char)reader.read();
                builder.append(c);
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getContent(@NotNull File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)stream, Charsets.UTF_8);
            BufferedReader input = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    builder.append(line);
                    builder.append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    input.close();
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return builder.toString();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException();
        }
    }
}

