/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.internal.evaluation;

import com.moderocky.guardian.mask.api.CaughtBreakable;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;

public class JavaEvaluator {
    @NotNull
    private final ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
    @NotNull
    private final List<String> strings = new ArrayList<String>();
    @NotNull
    private String content;

    public JavaEvaluator(@NotNull String string) {
        this.content = string;
    }

    public JavaEvaluator setContent(@NotNull String string) {
        this.content = string;
        return this;
    }

    public JavaEvaluator importClass(Class<?> ... aClasses) {
        for (Class<?> aClass : aClasses) {
            String s = aClass.getPackage().toString();
            if (s.matches("java\\.")) {
                this.strings.add(s);
                continue;
            }
            this.strings.add("Packages." + s);
        }
        return this;
    }

    public JavaEvaluator importPackage(String ... packageNames) {
        for (String packageName : packageNames) {
            if (packageName.matches("java\\.")) {
                this.strings.add(packageName);
                continue;
            }
            this.strings.add("Packages." + packageName);
        }
        return this;
    }

    public CaughtBreakable<JavaEvaluator> prepare() {
        try {
            String imports = String.join((CharSequence)",", this.strings);
            this.engine.eval("var imports = new JavaImporter(" + imports + ");");
        }
        catch (ScriptException e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
        return new CaughtBreakable<JavaEvaluator>(true, null, this);
    }

    public JavaEvaluator addReference(String string, Object object) {
        this.engine.put(string, object);
        return this;
    }

    public CaughtBreakable<Object> execute() {
        try {
            Object out = this.engine.eval("(function() {with (imports) {" + this.content + "}})();");
            return new CaughtBreakable<Object>(true, null, out);
        }
        catch (ScriptException e) {
            return new CaughtBreakable<Object>(false, e, null);
        }
    }
}

