/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.gui;

import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.gui.InventoryGUI;
import com.moderocky.guardian.mask.template.CompleteListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;

@API
public class MenuGUI
implements InventoryGUI,
CompleteListener {
    private final Inventory inventory;
    private final List<Player> players = new ArrayList<Player>();
    private final TreeMap<Integer, BiConsumer<Player, InventoryClickEvent>> map = new TreeMap();
    private final boolean editable;
    private final Plugin plugin;

    public MenuGUI(Plugin plugin, InventoryType type, String title) {
        this.plugin = plugin;
        if (!type.isCreatable()) {
            throw new IllegalArgumentException();
        }
        this.inventory = Bukkit.createInventory(null, (InventoryType)type, (String)title);
        this.editable = false;
    }

    public MenuGUI(Plugin plugin, int size, String title) {
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.editable = false;
    }

    private void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public int getSize() {
        return this.inventory.getSize();
    }

    public MenuGUI createButton(int slot, ItemStack itemStack, BiConsumer<Player, InventoryClickEvent> consumer) {
        this.map.put(slot, consumer);
        this.inventory.setItem(slot, itemStack);
        return this;
    }

    public MenuGUI createTile(int slot, ItemStack itemStack, boolean stealable) {
        BiConsumer<Player, InventoryClickEvent> consumer = (player, event) -> event.setCancelled(!stealable);
        this.map.put(slot, consumer);
        this.inventory.setItem(slot, itemStack);
        return this;
    }

    public MenuGUI createTile(ItemStack itemStack, Integer ... integers) {
        BiConsumer<Player, InventoryClickEvent> consumer = (player, event) -> event.setCancelled(true);
        for (Integer slot : integers) {
            this.map.put(slot, consumer);
            this.inventory.setItem(slot.intValue(), itemStack);
        }
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void open(Player player) {
        if (!this.hasListener()) {
            this.register();
        }
        player.openInventory(this.inventory);
        this.players.add(player);
    }

    @Override
    public boolean isOpen(Player player) {
        return this.players.contains(player);
    }

    @Override
    public InventoryType getType() {
        return this.inventory.getType();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.players.isEmpty()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.players.contains(player)) {
            return;
        }
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            return;
        }
        if (!clicked.equals(this.inventory)) {
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        if (!this.editable) {
            event.setCancelled(true);
        }
        if (!this.map.containsKey(event.getSlot())) {
            return;
        }
        this.map.get(event.getSlot()).accept(player, event);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (this.players.isEmpty()) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (event.getInventory() != this.inventory) {
            return;
        }
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        this.remove();
    }

    private void remove() {
        new BukkitRunnable(){

            public void run() {
                if (MenuGUI.this.players.isEmpty() && MenuGUI.this.hasListener()) {
                    MenuGUI.this.unregister();
                }
            }
        }.runTaskLater(this.plugin, 80L);
    }

    private boolean hasListener() {
        for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)this.plugin)) {
            if (listener.getListener() != this) continue;
            return true;
        }
        return false;
    }
}

