/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemFactory {
    @NotNull
    private final List<Consumer<ItemMeta>> consumers = new ArrayList<Consumer<ItemMeta>>();
    @NotNull
    private final List<Consumer<ItemStack>> itemEdits = new ArrayList<Consumer<ItemStack>>();
    @NotNull
    private Material material;
    @NotNull
    private ItemMeta meta;
    private int amount;

    public ItemFactory() {
        this.material = Material.AIR;
        this.amount = 1;
        this.meta = Bukkit.getItemFactory().getItemMeta(this.material);
    }

    public ItemFactory(@NotNull Material material) {
        this.material = material;
        this.amount = 1;
        this.meta = Bukkit.getItemFactory().getItemMeta(material);
    }

    public ItemFactory(@NotNull Material material, int amount) {
        this.material = material;
        this.amount = amount;
        this.meta = Bukkit.getItemFactory().getItemMeta(material);
    }

    public ItemFactory(@NotNull Material material, @NotNull Consumer<ItemMeta> consumer) {
        this.material = material;
        this.amount = 1;
        this.meta = Bukkit.getItemFactory().getItemMeta(material);
        this.consumers.add(consumer);
    }

    public ItemFactory(@NotNull Material material, int amount, @NotNull Consumer<ItemMeta> consumer) {
        this.material = material;
        this.amount = amount;
        this.meta = Bukkit.getItemFactory().getItemMeta(material);
        this.consumers.add(consumer);
    }

    public ItemFactory(@NotNull ItemStack itemStack) {
        this.material = itemStack.getType();
        this.meta = itemStack.getItemMeta();
        this.amount = itemStack.getAmount();
    }

    public ItemFactory setAmount(int i) {
        this.amount = i;
        return this;
    }

    @NotNull
    public <Q extends FactoryImplementation> Q accept(@NotNull Q implementation) {
        return implementation.setTarget(this);
    }

    public ItemFactory addConsumer(Consumer<ItemMeta> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    public ItemFactory addItemConsumer(Consumer<ItemStack> consumer) {
        this.itemEdits.add(consumer);
        return this;
    }

    public ItemFactory apply(ItemStack itemStack) {
        ItemMeta meta = this.meta.clone();
        try {
            for (Consumer<ItemMeta> consumer : this.consumers) {
                consumer.accept(meta);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        itemStack.setAmount(Math.max(0, Math.min(127, this.amount)));
        itemStack.setItemMeta(meta);
        for (Consumer<ItemMeta> consumer : this.itemEdits) {
            try {
                consumer.accept((ItemMeta)itemStack);
            }
            catch (Throwable throwable) {}
        }
        return this;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    public ItemFactory setMaterial(@NotNull Material material) {
        ItemMeta meta = Bukkit.getItemFactory().asMetaFor(this.meta, material);
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(material);
        }
        this.material = material;
        this.meta = meta;
        return this;
    }

    @NotNull
    public ItemMeta getItemMeta() {
        ItemMeta meta = this.meta.clone();
        try {
            for (Consumer<ItemMeta> consumer : this.consumers) {
                consumer.accept(meta);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return meta;
    }

    @NotNull
    public ItemStack create() {
        ItemStack itemStack = new ItemStack(this.material);
        itemStack.setAmount(Math.max(0, Math.min(127, this.amount)));
        ItemMeta meta = this.meta.clone();
        for (Consumer<ItemMeta> consumer : this.consumers) {
            try {
                consumer.accept(meta);
            }
            catch (Throwable throwable) {}
        }
        try {
            itemStack.setItemMeta(meta);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Consumer<ItemMeta> consumer : this.itemEdits) {
            try {
                consumer.accept((ItemMeta)itemStack);
            }
            catch (Throwable throwable) {}
        }
        return itemStack;
    }

    public static abstract class FactoryImplementation {
        private ItemFactory factory;

        public abstract ItemFactory apply(ItemFactory var1);

        <Q extends FactoryImplementation> Q setTarget(ItemFactory factory) {
            this.factory = factory;
            return (Q)this;
        }

        public ItemFactory getFactory() {
            return this.apply(this.factory);
        }
    }
}

