/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.command;

import com.moderocky.guardian.mask.command.Argument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ArgumentHandler {
    @NotNull
    private final List<Argument<?>> arguments = new ArrayList();

    public ArgumentHandler(Argument<?> ... arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
    }

    private Class<?>[] getTypeAcceptors() {
        ArrayList classes = new ArrayList();
        this.arguments.forEach(argument -> classes.add(argument.getType()));
        return classes.toArray(new Class[0]);
    }

    public boolean canAccept(String[] strings) {
        int i = 0;
        for (Argument<?> argument : this.arguments) {
            String string;
            if ((strings.length < i + 1 || strings[i].isEmpty()) && argument.isRequired()) {
                return false;
            }
            if (argument.isRequired()) {
                string = strings[i];
                if (!argument.matches(string)) {
                    return false;
                }
            } else {
                string = strings[i];
                if (i < strings.length - 1 && !argument.matches(string)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int getLength() {
        return this.arguments.size();
    }

    public String toString() {
        ArrayList<String> strings = new ArrayList<String>();
        for (Argument<?> argument : this.arguments) {
            StringBuilder string = new StringBuilder();
            if (argument.isRequired()) {
                string.append("<");
            } else {
                string.append("[");
            }
            if (argument.isPlural()) {
                string.append("*");
            }
            string.append(argument.getName());
            if (argument.isRequired()) {
                string.append(">");
            } else {
                string.append("]");
            }
            strings.add(string.toString());
        }
        return String.join((CharSequence)" ", strings);
    }
}

