/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public interface Compressive {
    public static final JsonParser JSON_PARSER = new JsonParser();

    default public byte[] createEmptyJson() {
        return this.zip(new JsonObject().toString());
    }

    default public byte[] zip(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(string.length());
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(string.getBytes());
            gzip.close();
            byte[] compressed = bos.toByteArray();
            bos.close();
            return compressed;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    default public String unzip(byte[] compressed) {
        if (!this.isZipped(compressed)) {
            return new String(compressed, StandardCharsets.UTF_8);
        }
        try {
            String line;
            ByteArrayInputStream stream = new ByteArrayInputStream(compressed);
            GZIPInputStream gzipInputStream = new GZIPInputStream(stream);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            gzipInputStream.close();
            stream.close();
            return builder.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    default public boolean isZipped(byte[] compressed) {
        if (compressed.length == 0) {
            return false;
        }
        return compressed[0] == 31 && compressed[1] == -117;
    }
}

