/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.mask.template.CompleteListener;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.jetbrains.annotations.NotNull;

public class EntitySpawnListener
implements CompleteListener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(EntitySpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType() == EntityType.PLAYER) {
            return;
        }
        Location location = event.getEntity().getLocation();
        for (Zone zone : this.api.getZones(location)) {
            if (zone.canInteract(location, "mob_spawning")) continue;
            event.setCancelled(true);
            break;
        }
    }
}

