/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.PolyhedralZone;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.logic.handler.LogicUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Vertices (Corners) of Zone")
@Description(value={"Returns the vertices (corners) of a Guardian zone. ", "For cubic zones, this will be the corners. ", "For polyhedral zones, this will be the vertices. ", "Other zone types may not anything. "})
@Examples(value={"set {_corners::*} to the corners of zone \"my_zone\""})
@Since(value="1.0.5")
public class ZoneVerticesExpr
extends SimpleExpression<Location> {
    private Expression<String> stringExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        return true;
    }

    protected Location[] get(@NotNull Event event) {
        String id = (String)this.stringExpression.getSingle(event);
        if (id == null) {
            return new Location[0];
        }
        GuardianAPI api = Guardian.getApi();
        if (!api.exists(id)) {
            return new Location[0];
        }
        Zone zone = api.getZone(id);
        ArrayList<Location> locations = new ArrayList<Location>();
        if (zone instanceof CuboidalZone) {
            locations.addAll(LogicUtils.toLocations(LogicUtils.getVertices(zone.getBoundingBox()), zone.getWorld()));
        } else if (zone instanceof PolyhedralZone) {
            locations.addAll(LogicUtils.toLocations(((PolyhedralZone)zone).getPolyhedron().getVertices(), zone.getWorld()));
        }
        return locations.toArray(new Location[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        return "vertices of zone " + string;
    }

    static {
        Skript.registerExpression(ZoneVerticesExpr.class, Location.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] (vertices|corners) of [guardian] zone %string%", "[guardian] zone %string%'s (vertices|corners)"});
    }
}

