/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.CuboidalZone;
import com.moderocky.guardian.api.GuardianAPI;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Create Zone")
@Description(value={"Creates a Guardian zone between the specified locations.", "Note: this will overlap any existing zones."})
@Examples(value={"create zone \"my_cool_zone\" between {_corner1} and {_corner2}"})
@Since(value="1.0.4")
public class CreateZoneEffect
extends Effect {
    private Expression<String> stringExpression;
    private Expression<Location> locationExpression1;
    private Expression<Location> locationExpression2;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.stringExpression = exprs[0];
        this.locationExpression1 = exprs[1];
        this.locationExpression2 = exprs[2];
        return true;
    }

    protected void execute(@NotNull Event event) {
        if (this.stringExpression == null || this.locationExpression1 == null || this.locationExpression2 == null) {
            return;
        }
        String id = (String)this.stringExpression.getSingle(event);
        Location l1 = (Location)this.locationExpression1.getSingle(event);
        Location l2 = (Location)this.locationExpression2.getSingle(event);
        if (id == null || l1 == null || l2 == null) {
            return;
        }
        id = id.replace(" ", "_").toLowerCase().replaceAll("([^a-z0-9_-]+)", "_");
        while (id.contains("__")) {
            id = id.replace("__", "_");
        }
        if (l1.getWorld() != l2.getWorld()) {
            return;
        }
        GuardianAPI api = Guardian.getApi();
        if (api.exists(id)) {
            return;
        }
        CuboidalZone zone = CuboidalZone.createZone(id, l1, l2);
        api.registerZone(zone);
        api.scheduleSave();
        api.updateCache();
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        String string = "<none>";
        String l1 = "<none>";
        String l2 = "<none>";
        if (this.stringExpression != null) {
            string = this.stringExpression.toString(event, debug);
        }
        if (this.locationExpression1 != null) {
            l1 = this.locationExpression1.toString(event, debug);
        }
        if (this.locationExpression2 != null) {
            l2 = this.locationExpression2.toString(event, debug);
        }
        return "create zone " + string + " between " + l1 + " and " + l2;
    }

    static {
        Skript.registerEffect(CreateZoneEffect.class, (String[])new String[]{"create [guardian] zone %string% between %location% and %location%"});
    }
}

