/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.skript.condition;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Can Perform Action")
@Description(value={"Check if a given action can be performed at a location. "})
@Examples(value={"add player to the allowed players of zone \"my_zone\"", "add player and target player to the allowed players of zone \"my_zone\"", "add {some_players::*} to guardian zone \"my_zone\"'s allowed players", "reset zone \"my_zone\"'s allowed players", "set guardian zone \"my_zone\"'s allowed players to {list_of_players::*}"})
@Since(value="1.0.5")
public class CanPerformCond
extends Condition {
    private Expression<String> stringExpression;
    private Expression<Location> locationExpression;
    private Expression<Player> playerExpression;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.playerExpression = exprs[0];
        this.stringExpression = exprs[1];
        this.locationExpression = exprs[2];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event event) {
        GuardianAPI api = Guardian.getApi();
        return this.playerExpression.check(event, player -> {
            Location location = (Location)this.locationExpression.getSingle(event);
            String string = (String)this.stringExpression.getSingle(event);
            for (Zone zone : api.getZones(location)) {
                assert (location != null);
                assert (string != null);
                if (zone.canInteract(location, string, (Player)player)) continue;
                return false;
            }
            return true;
        }, this.isNegated());
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)event, (boolean)debug, this.playerExpression, (String)("can perform " + this.stringExpression.toString(event, debug) + " at " + this.locationExpression.toString(event, debug)));
    }

    static {
        PropertyCondition.register(CanPerformCond.class, (String)"can perform %string% at %location%", (String)"players");
    }
}

