/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.template;

import com.moderocky.guardian.mask.annotation.API;
import com.moderocky.guardian.mask.template.CompleteCommand;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
public interface WrappedCommand
extends CompleteCommand {
    @NotNull
    public List<String> getAliases();

    @NotNull
    public String getUsage();

    @NotNull
    public String getDescription();

    @Nullable
    public String getPermission();

    @Nullable
    public String getPermissionMessage();

    default public void register(Plugin plugin) {
        WrappedCommand command = this;
        try {
            Constructor commandConstructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            if (!commandConstructor.isAccessible()) {
                commandConstructor.setAccessible(true);
            }
            PluginCommand pluginCommand = (PluginCommand)commandConstructor.newInstance(command.getCommand(), plugin);
            pluginCommand.setAliases(command.getAliases());
            pluginCommand.setDescription(command.getDescription());
            pluginCommand.setPermission(command.getPermission());
            pluginCommand.setPermissionMessage(command.getPermissionMessage());
            pluginCommand.setUsage(command.getUsage());
            pluginCommand.register(Bukkit.getServer().getCommandMap());
            if (Bukkit.getServer().getCommandMap().register(command.getCommand(), plugin.getName(), (Command)pluginCommand)) {
                pluginCommand.setExecutor((CommandExecutor)command);
                pluginCommand.setTabCompleter((TabCompleter)command);
            } else {
                Command com = Bukkit.getServer().getCommandMap().getCommand(pluginCommand.getName());
                if (com instanceof PluginCommand) {
                    ((PluginCommand)com).setExecutor((CommandExecutor)command);
                    ((PluginCommand)com).setTabCompleter((TabCompleter)command);
                }
                Bukkit.getLogger().log(Level.WARNING, "A command '/" + command.getCommand() + "' is already defined!");
                Bukkit.getLogger().log(Level.WARNING, "As this cannot be replaced, the executor will be overridden.");
                Bukkit.getLogger().log(Level.WARNING, "To avoid this warning, please do not add WrappedCommands to your plugin.yml.");
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

