/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.mask.mirror;

import com.moderocky.guardian.mask.mirror.IMirror;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstructorMirror<T>
implements IMirror<T> {
    @NotNull
    private final transient Constructor<T> constructor;
    @NotNull
    private final transient IMirror<?> parent;
    @NotNull
    private final transient Object target;

    public ConstructorMirror(@NotNull Constructor<T> constructor, @NotNull IMirror<?> parent, @NotNull Object target) {
        this.constructor = constructor;
        this.parent = parent;
        this.target = target;
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
    }

    @Override
    public <Q extends Annotation> boolean hasAnnotation(Class<Q> annotation) {
        return this.constructor.getDeclaredAnnotation(annotation) != null;
    }

    @Override
    public <Q extends Annotation> Q getAnnotation(Class<Q> annotation) {
        return this.constructor.getDeclaredAnnotation(annotation);
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    public int getParameterCount() {
        return this.constructor.getParameterCount();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.constructor.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.constructor.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.constructor.getModifiers());
    }

    @Override
    public String getName() {
        return this.constructor.getName();
    }

    public T newInstance(Object ... params) {
        try {
            return this.constructor.newInstance(params);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void newInstance(@Nullable Consumer<T> success, @Nullable Consumer<Throwable> failure, Object ... params) {
        block3: {
            try {
                if (success != null) {
                    success.accept(this.newInstance(params));
                }
            }
            catch (Throwable throwable) {
                if (failure == null) break block3;
                failure.accept(throwable);
            }
        }
    }

    public boolean willAccept(Object ... params) {
        Class<?>[] types = this.constructor.getParameterTypes();
        if (types.length == 0 && (params == null || params.length == 0)) {
            return true;
        }
        if (types.length != params.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (params[i].getClass().equals(types[i]) || params[i].getClass().isAssignableFrom(types[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <Q> IMirror<Q> getParent() {
        return this.parent;
    }

    @Override
    public <Q> Q getTarget() {
        return (Q)this.target;
    }

    @Override
    public Constructor<T> getLiteral() {
        return this.constructor;
    }
}

