/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.logic.ascendancy;

import com.moderocky.guardian.logic.shape.Vertex;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public interface Polytope {
    public int getOrder();

    default public int getMinimumVertices() {
        return this.getOrder() + 1;
    }

    public Vertex[] vertices();

    public boolean contains(Polytope var1);

    default public boolean hasLockingPoint(@NotNull Polytope polytope) {
        for (Vertex vertex : polytope.vertices()) {
            for (Vertex vx : this.vertices()) {
                if (!vertex.equals(vx)) continue;
                return true;
            }
        }
        return false;
    }

    default public Vertex[][] getLockingPoints(@NotNull Polytope polytope) {
        ArrayList<Vertex[]> vertices = new ArrayList<Vertex[]>();
        for (Vertex vertex : polytope.vertices()) {
            for (Vertex vx : this.vertices()) {
                if (!vertex.equals(vx)) continue;
                vertices.add(new Vertex[]{vx, vertex});
            }
        }
        return (Vertex[][])vertices.toArray((T[])new Vertex[0][]);
    }
}

