/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.guardian.listener;

import com.moderocky.guardian.Guardian;
import com.moderocky.guardian.api.GuardianAPI;
import com.moderocky.guardian.api.Zone;
import com.moderocky.guardian.config.GuardianConfig;
import com.moderocky.guardian.mask.template.CompleteListener;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class PlayerInteractListener
implements CompleteListener {
    @NotNull
    private final GuardianAPI api = Guardian.getApi();
    @NotNull
    private final GuardianConfig config = Guardian.getInstance().getGuardianConfig();

    @EventHandler
    public void onPlayerWandInteract(PlayerInteractEvent event) {
        if (!this.config.enableWand) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            return;
        }
        if (block == null) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (this.api.isWand(itemStack)) {
            event.setCancelled(true);
            Location location = block.getLocation().add(0.5, 0.5, 0.5).add(event.getBlockFace().getDirection().normalize().multiply(0.5));
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                player.getPersistentDataContainer().set(Guardian.getNamespacedKey("wand_pos_1"), PersistentDataType.STRING, (Object)this.api.serialisePosition(block.getLocation()));
                location.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 12, (Object)Material.REDSTONE_BLOCK.createBlockData());
                player.sendActionBar(this.config.setPosition.replace("%s", "1"));
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                player.getPersistentDataContainer().set(Guardian.getNamespacedKey("wand_pos_2"), PersistentDataType.STRING, (Object)this.api.serialisePosition(block.getLocation()));
                location.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 12, (Object)Material.LAPIS_BLOCK.createBlockData());
                player.sendActionBar(this.config.setPosition.replace("%s", "2"));
            }
            this.api.displayBox(player);
        } else if (this.api.isPolywand(itemStack)) {
            event.setCancelled(true);
            Location location = block.getLocation().add(0.5, 0.5, 0.5).add(event.getBlockFace().getDirection().normalize().multiply(0.5));
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                String des = (String)player.getPersistentDataContainer().get(Guardian.getNamespacedKey("polywand_pos"), PersistentDataType.STRING);
                if (des == null) {
                    des = "";
                }
                des = des.length() > 0 ? des + "/" + this.api.serialisePosition(block.getLocation()) : this.api.serialisePosition(block.getLocation());
                player.getPersistentDataContainer().set(Guardian.getNamespacedKey("polywand_pos"), PersistentDataType.STRING, (Object)des);
                location.getWorld().spawnParticle(Particle.BLOCK_DUST, location, 12, (Object)Material.REDSTONE_BLOCK.createBlockData());
                player.sendActionBar(this.config.setPosition.replace("%s", des.split("/").length + ""));
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                player.getPersistentDataContainer().set(Guardian.getNamespacedKey("polywand_pos"), PersistentDataType.STRING, (Object)"");
                player.sendActionBar(this.config.clearPosition);
            }
            this.api.displayPolyBox(player);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onRegion(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location location = block.getLocation();
        Player player = event.getPlayer();
        for (Zone zone : this.api.getZones(location)) {
            if (zone.canInteract(location, "interact_with_blocks", player)) continue;
            event.setCancelled(true);
            this.api.denyEvent(player);
            return;
        }
    }
}

